/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.mqtt.service;

import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.extend.mqtt.service.MqttClientManager;
import org.noear.solon.cloud.extend.mqtt.service.MqttMessageListenerImpl;
import org.noear.solon.cloud.model.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttMessageHandler
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(MqttMessageListenerImpl.class);
    private MqttClientManager clientManager;
    private String eventChannelName;
    private CloudEventHandler eventHandler;
    private String topic;
    private MqttMessage message;

    public MqttMessageHandler(MqttClientManager clientManager, String eventChannelName, CloudEventHandler eventHandler, String topic, MqttMessage message) {
        this.clientManager = clientManager;
        this.eventChannelName = eventChannelName;
        this.eventHandler = eventHandler;
        this.topic = topic;
        this.message = message;
    }

    @Override
    public void run() {
        try {
            Event event = new Event(this.topic, new String(this.message.getPayload())).qos(this.message.getQos()).retained(this.message.isRetained()).channel(this.eventChannelName);
            if (this.eventHandler != null) {
                if (this.eventHandler.handle(event)) {
                    this.clientManager.getClient().messageArrivedComplete(this.message.getId(), this.message.getQos());
                }
            } else {
                this.clientManager.getClient().messageArrivedComplete(this.message.getId(), this.message.getQos());
                log.warn("There is no observer for this event topic[{}]", (Object)event.topic());
            }
        }
        catch (Throwable e) {
            e = Utils.throwableUnwrap((Throwable)e);
            log.warn(e.getMessage(), e);
        }
    }
}

