/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.mqtt.service;

import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.annotation.EventLevel;
import org.noear.solon.cloud.exception.CloudEventException;
import org.noear.solon.cloud.extend.mqtt.service.MqttClientManager;
import org.noear.solon.cloud.extend.mqtt.service.MqttClientManagerImpl;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.model.EventTran;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.noear.solon.cloud.service.CloudEventServicePlus;
import org.noear.solon.core.bean.LifecycleBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudEventServiceMqtt3
implements CloudEventServicePlus,
LifecycleBean {
    private static final Logger log = LoggerFactory.getLogger(CloudEventServiceMqtt3.class);
    private final CloudProps cloudProps;
    private final long publishTimeout;
    private MqttClientManagerImpl clientManager;
    private CloudEventObserverManger observerMap = new CloudEventObserverManger();
    private String channel;
    private String group;

    public MqttClientManager getClientManager() {
        return this.clientManager;
    }

    public CloudEventServiceMqtt3(CloudProps cloudProps) {
        this.cloudProps = cloudProps;
        this.publishTimeout = cloudProps.getEventPublishTimeout();
        this.clientManager = new MqttClientManagerImpl(this.observerMap, cloudProps);
    }

    private void beginTransaction(EventTran transaction) throws CloudEventException {
        log.warn("Event transactions are not supported!");
    }

    public boolean publish(Event event) throws CloudEventException {
        if (event.tran() != null) {
            this.beginTransaction(event.tran());
        }
        MqttMessage message = new MqttMessage();
        message.setQos(event.qos());
        message.setRetained(event.retained());
        message.setPayload(event.content().getBytes());
        try {
            IMqttDeliveryToken token = this.clientManager.getClient().publish(event.topic(), message);
            if (!this.clientManager.getAsync() && event.qos() > 0) {
                token.waitForCompletion(this.publishTimeout);
                return token.isComplete();
            }
            return true;
        }
        catch (Throwable ex) {
            throw new CloudEventException(ex);
        }
    }

    public void attention(EventLevel level, String channel, String group, String topic, String tag, int qos, CloudEventHandler observer) {
        this.observerMap.add(topic, level, group, topic, tag, qos, observer);
    }

    public void postStart() throws Throwable {
        this.subscribe();
    }

    private void subscribe() {
        try {
            this.clientManager.getClient();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getChannel() {
        if (this.channel == null) {
            this.channel = this.cloudProps.getEventChannel();
        }
        return this.channel;
    }

    public String getGroup() {
        if (this.group == null) {
            this.group = this.cloudProps.getEventGroup();
        }
        return this.group;
    }
}

