/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.aliyun.oss.service;

import java.time.Duration;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.exception.CloudFileException;
import org.noear.solon.cloud.extend.aliyun.oss.service.Datetime;
import org.noear.solon.cloud.model.Media;
import org.noear.solon.cloud.service.CloudFileService;
import org.noear.solon.core.handle.Result;
import org.noear.solon.net.http.HttpResponse;
import org.noear.solon.net.http.HttpUtils;

public class CloudFileServiceOssImpl
implements CloudFileService {
    private static final String CHARSET_UTF8 = "utf8";
    private static final String ALGORITHM = "HmacSHA1";
    private final String bucketDef;
    private final String accessKey;
    private final String secretKey;
    private final String endpoint;

    public CloudFileServiceOssImpl(CloudProps cloudProps) {
        this(cloudProps.getFileEndpoint(), cloudProps.getFileBucket(), cloudProps.getFileAccessKey(), cloudProps.getFileSecretKey());
    }

    public CloudFileServiceOssImpl(String endpoint, String bucket, String accessKey, String secretKey) {
        if (Utils.isEmpty((String)endpoint)) {
            throw new IllegalArgumentException("The endpoint configuration is missing");
        }
        this.endpoint = endpoint;
        this.bucketDef = bucket;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    public boolean exists(String bucket, String key) throws CloudFileException {
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        try {
            String date = Datetime.Now().toGmtString();
            String objPath = "/" + bucket + "/" + key;
            String url = this.buildUrl(bucket, key);
            String Signature = this.hmacSha1(CloudFileServiceOssImpl.buildSignData("HEAD", date, objPath, null), this.secretKey);
            String Authorization = "OSS " + this.accessKey + ":" + Signature;
            HashMap<String, String> head = new HashMap<String, String>();
            head.put("Date", date);
            head.put("Authorization", Authorization);
            int code = HttpUtils.http((String)url).header("Date", date).header("Authorization", Authorization).execAsCode("HEAD");
            return code == 200;
        }
        catch (Exception ex) {
            throw new CloudFileException((Throwable)ex);
        }
    }

    public String getTempUrl(String bucket, String key, Duration duration) throws CloudFileException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Media get(String bucket, String key) throws CloudFileException {
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        try {
            String date = Datetime.Now().toGmtString();
            String objPath = "/" + bucket + "/" + key;
            String url = this.buildUrl(bucket, key);
            String Signature = this.hmacSha1(CloudFileServiceOssImpl.buildSignData("GET", date, objPath, null), this.secretKey);
            String Authorization = "OSS " + this.accessKey + ":" + Signature;
            HashMap<String, String> head = new HashMap<String, String>();
            head.put("Date", date);
            head.put("Authorization", Authorization);
            HttpResponse resp = HttpUtils.http((String)url).header("Date", date).header("Authorization", Authorization).exec("GET");
            return new Media(resp.body(), resp.contentType(), resp.contentLength().longValue());
        }
        catch (Exception ex) {
            throw new CloudFileException((Throwable)ex);
        }
    }

    public Result put(String bucket, String key, Media media) throws CloudFileException {
        String streamMime;
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        if (Utils.isEmpty((String)(streamMime = media.contentType()))) {
            streamMime = "text/plain; charset=utf-8";
        }
        try {
            String date = Datetime.Now().toGmtString();
            String objPath = "/" + bucket + "/" + key;
            String url = this.buildUrl(bucket, key);
            String Signature = this.hmacSha1(CloudFileServiceOssImpl.buildSignData("PUT", date, objPath, streamMime), this.secretKey);
            String Authorization = "OSS " + this.accessKey + ":" + Signature;
            String tmp = HttpUtils.http((String)url).header("Date", date).header("Authorization", Authorization).bodyRaw(media.body(), streamMime).put();
            return Result.succeed((Object)tmp);
        }
        catch (Exception ex) {
            throw new CloudFileException((Throwable)ex);
        }
    }

    public Result delete(String bucket, String key) throws CloudFileException {
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        try {
            String date = Datetime.Now().toGmtString();
            String objPath = "/" + bucket + "/" + key;
            String url = this.buildUrl(bucket, key);
            String Signature = this.hmacSha1(CloudFileServiceOssImpl.buildSignData("DELETE", date, objPath, null), this.secretKey);
            String Authorization = "OSS " + this.accessKey + ":" + Signature;
            String tmp = HttpUtils.http((String)url).header("Date", date).header("Authorization", Authorization).delete();
            return Result.succeed((Object)tmp);
        }
        catch (Exception ex) {
            throw new CloudFileException((Throwable)ex);
        }
    }

    public Result deleteBatch(String bucket, Collection<String> keys) throws CloudFileException {
        for (String key : keys) {
            this.delete(bucket, key);
        }
        return Result.succeed();
    }

    private String buildUrl(String bucket, String key) {
        if (this.endpoint.startsWith(bucket)) {
            return "https://" + this.endpoint + "/" + key;
        }
        return "https://" + bucket + "." + this.endpoint + "/" + key;
    }

    private String hmacSha1(String data, String key) {
        try {
            Mac mac = Mac.getInstance(ALGORITHM);
            SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(), ALGORITHM);
            mac.init(keySpec);
            byte[] rawHmac = mac.doFinal(data.getBytes(CHARSET_UTF8));
            return Base64.getEncoder().encodeToString(rawHmac);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String buildSignData(String method, String date, String objPath, String contentType) {
        if (contentType == null) {
            return method + "\n\n\n" + date + "\n" + objPath;
        }
        return method + "\n\n" + contentType + "\n" + date + "\n" + objPath;
    }
}

