/*
 * Decompiled with CFR 0.152.
 */
package ninja.servlet;

import com.google.inject.servlet.GuiceFilter;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.Endpoint;
import ninja.websockets.WebSocketUtils;
import ninja.websockets.jsr356.Jsr356Handshake;
import ninja.websockets.jsr356.Jsr356HandshakePrincipal;
import ninja.websockets.jsr356.Jsr356HandshakeThreadLocal;

public class NinjaServletFilter
implements Filter {
    private final GuiceFilter wrapped = new GuiceFilter();

    public void init(FilterConfig filterConfig) throws ServletException {
        this.wrapped.init(filterConfig);
    }

    public void destroy() {
        this.wrapped.destroy();
    }

    private boolean isWebSocketHandshake(HttpServletRequest httpRequest) {
        String upgradeHeader = httpRequest.getHeader("Upgrade");
        return upgradeHeader != null && "websocket".equalsIgnoreCase(upgradeHeader);
    }

    public HttpServletRequest buildWebSocketHandshakeHttpRequest(HttpServletRequest httpRequest, Jsr356Handshake handshake) {
        httpRequest.setAttribute("ninja.websocket.handshake", (Object)handshake);
        return new HttpServletRequestWrapper(httpRequest){

            public String getMethod() {
                return "WS";
            }
        };
    }

    public HttpServletRequest buildWebSocketUpgradeHttpRequest(HttpServletRequest httpRequest, Jsr356Handshake handshake) {
        final Jsr356HandshakePrincipal principal = new Jsr356HandshakePrincipal(httpRequest.getUserPrincipal(), handshake);
        return new HttpServletRequestWrapper(httpRequest){

            public Principal getUserPrincipal() {
                return principal;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (!this.isWebSocketHandshake(httpRequest)) {
            this.wrapped.doFilter(request, response, chain);
        } else {
            Jsr356Handshake handshake = new Jsr356Handshake();
            handshake.setRequestedProtocols(WebSocketUtils.parseProtocolRequestHeader((String)httpRequest.getHeader("Sec-WebSocket-Protocol")));
            this.wrapped.doFilter((ServletRequest)this.buildWebSocketHandshakeHttpRequest(httpRequest, handshake), response, chain);
            if (httpResponse.getStatus() == 101) {
                handshake.setEndpoint((Endpoint)httpRequest.getAttribute("ninja.websocket.endpoint"));
                Jsr356HandshakeThreadLocal.set((Jsr356Handshake)handshake);
                try {
                    httpRequest = this.buildWebSocketUpgradeHttpRequest(httpRequest, handshake);
                    chain.doFilter((ServletRequest)httpRequest, response);
                }
                finally {
                    Jsr356HandshakeThreadLocal.remove();
                }
            }
        }
    }
}

