/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.structs;

import com.anotherbigidea.io.InStream;
import com.anotherbigidea.io.OutStream;
import java.io.IOException;

public class Matrix {
    protected double scaleX = 1.0;
    protected double scaleY = 1.0;
    protected double skew0 = 0.0;
    protected double skew1 = 0.0;
    protected double translateX = 0.0;
    protected double translateY = 0.0;

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public double getSkew0() {
        return this.skew0;
    }

    public double getSkew1() {
        return this.skew1;
    }

    public double getTranslateX() {
        return this.translateX;
    }

    public double getTranslateY() {
        return this.translateY;
    }

    public void setScaleX(double scaleX) {
        this.scaleX = scaleX;
    }

    public void setScaleY(double scaleY) {
        this.scaleY = scaleY;
    }

    public void setSkew0(double skew0) {
        this.skew0 = skew0;
    }

    public void setSkew1(double skew1) {
        this.skew1 = skew1;
    }

    public void setTranslateX(double translateX) {
        this.translateX = translateX;
    }

    public void setTranslateY(double translateY) {
        this.translateY = translateY;
    }

    public Matrix() {
        this(1.0, 1.0, 0.0, 0.0, 0.0, 0.0);
    }

    public Matrix(double translateX, double translateY) {
        this(1.0, 1.0, 0.0, 0.0, translateX, translateY);
    }

    public Matrix(Matrix copy) {
        if (copy == null) {
            return;
        }
        this.scaleX = copy.scaleX;
        this.scaleY = copy.scaleY;
        this.skew0 = copy.skew0;
        this.skew1 = copy.skew1;
        this.translateX = copy.translateX;
        this.translateY = copy.translateY;
    }

    public Matrix(double scaleX, double scaleY, double skew0, double skew1, double translateX, double translateY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.skew0 = skew0;
        this.skew1 = skew1;
        this.setTranslateX(translateX);
        this.setTranslateY(translateY);
    }

    public Matrix(InStream in) throws IOException {
        in.synchBits();
        if (in.readUBits(1) == 1L) {
            int scaleBits = (int)in.readUBits(5);
            this.scaleX = (double)in.readSBits(scaleBits) / 65536.0;
            this.scaleY = (double)in.readSBits(scaleBits) / 65536.0;
        }
        if (in.readUBits(1) == 1L) {
            int skewBits = (int)in.readUBits(5);
            this.skew0 = (double)in.readSBits(skewBits) / 65536.0;
            this.skew1 = (double)in.readSBits(skewBits) / 65536.0;
        }
        int translateBits = (int)in.readUBits(5);
        this.translateX = in.readSBits(translateBits);
        this.translateY = in.readSBits(translateBits);
    }

    public void write(OutStream out) throws IOException {
        out.flushBits();
        if (this.scaleX != 1.0 || this.scaleY != 1.0) {
            int intScaleX = (int)(this.scaleX * 65536.0);
            int intScaleY = (int)(this.scaleY * 65536.0);
            int scaleBits = OutStream.determineSignedBitSize(intScaleX);
            int scaleBits2 = OutStream.determineSignedBitSize(intScaleY);
            if (scaleBits < scaleBits2) {
                scaleBits = scaleBits2;
            }
            out.writeUBits(1, 1L);
            out.writeUBits(5, scaleBits);
            out.writeSBits(scaleBits, intScaleX);
            out.writeSBits(scaleBits, intScaleY);
        } else {
            out.writeUBits(1, 0L);
        }
        if (this.skew0 != 0.0 || this.skew1 != 0.0) {
            int intSkew0 = (int)(this.skew0 * 65536.0);
            int intSkew1 = (int)(this.skew1 * 65536.0);
            int skewBits = OutStream.determineSignedBitSize(intSkew0);
            int skewBits2 = OutStream.determineSignedBitSize(intSkew1);
            if (skewBits < skewBits2) {
                skewBits = skewBits2;
            }
            out.writeUBits(1, 1L);
            out.writeUBits(5, skewBits);
            out.writeSBits(skewBits, intSkew0);
            out.writeSBits(skewBits, intSkew1);
        } else {
            out.writeUBits(1, 0L);
        }
        if (this.translateX == 0.0 && this.translateY == 0.0) {
            out.writeUBits(5, 0L);
        } else {
            int translateBits = OutStream.determineSignedBitSize((int)this.translateX);
            int translateBits2 = OutStream.determineSignedBitSize((int)this.translateY);
            if (translateBits < translateBits2) {
                translateBits = translateBits2;
            }
            out.writeUBits(5, translateBits);
            out.writeSBits(translateBits, (int)this.translateX);
            out.writeSBits(translateBits, (int)this.translateY);
        }
        out.flushBits();
    }

    public String toString() {
        return " Matrix(sx,sy,s0,s1,tx,ty)=(" + this.scaleX + "," + this.scaleY + "," + this.skew0 + "," + this.skew1 + "," + this.translateX + "," + this.translateY + ")";
    }
}

