/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.structs;

import com.anotherbigidea.flash.structs.Matrix;
import com.anotherbigidea.io.InStream;
import com.anotherbigidea.io.OutStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class ButtonRecord {
    public static final int BUTTON_HITTEST = 8;
    public static final int BUTTON_DOWN = 4;
    public static final int BUTTON_OVER = 2;
    public static final int BUTTON_UP = 1;
    protected int flags;
    protected int id;
    protected int layer;
    protected Matrix matrix;

    public int getCharId() {
        return this.id;
    }

    public int getLayer() {
        return this.layer;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isHitTest() {
        return (this.flags & 8) != 0;
    }

    public boolean isDown() {
        return (this.flags & 4) != 0;
    }

    public boolean isOver() {
        return (this.flags & 2) != 0;
    }

    public boolean isUp() {
        return (this.flags & 1) != 0;
    }

    public void setCharId(int id) {
        this.id = id;
    }

    public void setLayer(int layer) {
        this.layer = layer;
    }

    public void setMatrix(Matrix matrix) {
        this.matrix = matrix;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public static Vector read(InStream in) throws IOException {
        Vector<ButtonRecord> records = new Vector<ButtonRecord>();
        int firstByte = 0;
        while ((firstByte = in.readUI8()) != 0) {
            records.addElement(new ButtonRecord(in, firstByte));
        }
        return records;
    }

    public static void write(OutStream out, Vector records) throws IOException {
        Enumeration enum_ = records.elements();
        while (enum_.hasMoreElements()) {
            ButtonRecord rec = (ButtonRecord)enum_.nextElement();
            rec.write(out);
        }
        out.writeUI8(0);
    }

    public ButtonRecord(int id, int layer, Matrix matrix, int flags) {
        this.id = id;
        this.layer = layer;
        this.matrix = matrix;
        this.flags = flags;
    }

    protected ButtonRecord(InStream in, int firstByte) throws IOException {
        this.flags = firstByte;
        this.id = in.readUI16();
        this.layer = in.readUI16();
        this.matrix = new Matrix(in);
    }

    protected void write(OutStream out) throws IOException {
        out.writeUI8(this.flags);
        out.writeUI16(this.id);
        out.writeUI16(this.layer);
        this.matrix.write(out);
    }

    public String toString() {
        return "layer=" + this.layer + " id=" + this.id + " flags=" + Integer.toBinaryString(this.flags) + " " + this.matrix;
    }
}

