/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.movie;

import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.movie.ExportedSymbol;
import com.anotherbigidea.flash.movie.Frame;
import com.anotherbigidea.flash.movie.ImportedSymbol;
import com.anotherbigidea.flash.movie.Symbol;
import com.anotherbigidea.flash.movie.TimeLine;
import com.anotherbigidea.flash.structs.Color;
import com.anotherbigidea.flash.writers.SWFWriter;
import com.anotherbigidea.flash.writers.TagWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class Movie
implements TimeLine {
    protected int width;
    protected int height;
    protected int frameRate;
    protected Color backColor;
    protected int version;
    protected boolean isProtected;
    protected Map importLibraries;
    protected Vector exportedSymbols;
    protected SortedMap frames = new TreeMap();
    protected int frameCount = 0;
    protected HashMap definedSymbols = new HashMap();
    protected int depth = 1;
    protected int maxId = 1;

    public Movie() {
        this.width = 550;
        this.height = 400;
        this.frameRate = 12;
        this.version = 5;
    }

    public Movie(int width, int height, int frameRate, int version, Color backColor) {
        this.width = width;
        this.height = height;
        this.frameRate = frameRate;
        this.version = version;
        this.backColor = backColor;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public int getVersion() {
        return this.version;
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setFrameRate(int rate) {
        this.frameRate = rate;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setBackColor(Color color) {
        this.backColor = color;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public void protect(boolean isProtected) {
        this.isProtected = isProtected;
    }

    @Override
    public int getFrameCount() {
        return this.frameCount;
    }

    @Override
    public Frame getFrame(int frameNumber) {
        if (frameNumber < 1) {
            return null;
        }
        Integer num = new Integer(frameNumber);
        Frame frame = (Frame)this.frames.get(num);
        if (frame == null) {
            frame = new Frame(frameNumber, this);
            this.frames.put(num, frame);
            if (frameNumber > this.frameCount) {
                this.frameCount = frameNumber;
            }
        }
        return frame;
    }

    @Override
    public Frame appendFrame() {
        ++this.frameCount;
        Frame frame = new Frame(this.frameCount, this);
        this.frames.put(new Integer(this.frameCount), frame);
        return frame;
    }

    @Override
    public int getAvailableDepth() {
        return this.depth;
    }

    @Override
    public void setAvailableDepth(int depth) {
        if (depth < 1) {
            return;
        }
        this.depth = depth;
    }

    public ImportedSymbol[] importSymbols(String libraryName, String[] symbolNames) {
        ArrayList<ImportedSymbol> imports;
        if (this.importLibraries == null) {
            this.importLibraries = new HashMap();
        }
        if ((imports = (ArrayList<ImportedSymbol>)this.importLibraries.get(libraryName)) == null) {
            imports = new ArrayList<ImportedSymbol>();
            this.importLibraries.put(libraryName, imports);
        }
        ImportedSymbol[] symbols = new ImportedSymbol[symbolNames.length];
        for (int i = 0; i < symbolNames.length; ++i) {
            ImportedSymbol imp;
            symbols[i] = imp = new ImportedSymbol(0, symbolNames[i], libraryName);
            imports.add(imp);
        }
        return symbols;
    }

    public void clearImports() {
        if (this.importLibraries != null) {
            this.importLibraries.clear();
        }
    }

    public ImportedSymbol[] getImportedSymbols() {
        if (this.importLibraries == null) {
            return new ImportedSymbol[0];
        }
        Vector imports = new Vector();
        for (List list : this.importLibraries.values()) {
            Iterator i2 = list.iterator();
            while (i2.hasNext()) {
                imports.add(i2.next());
            }
        }
        Object[] imps = new ImportedSymbol[imports.size()];
        imports.copyInto(imps);
        return imps;
    }

    public void exportSymbols(String[] exportNames, Symbol[] symbols) {
        if (this.exportedSymbols == null) {
            this.exportedSymbols = new Vector();
        }
        for (int i = 0; i < exportNames.length && i < symbols.length; ++i) {
            this.exportedSymbols.add(new ExportedSymbol(symbols[i], exportNames[i]));
        }
    }

    public ExportedSymbol[] getExportedSymbols() {
        if (this.exportedSymbols == null) {
            return new ExportedSymbol[0];
        }
        Object[] exports = new ExportedSymbol[this.exportedSymbols.size()];
        this.exportedSymbols.copyInto(exports);
        return exports;
    }

    public void clearExports() {
        if (this.exportedSymbols != null) {
            this.exportedSymbols.clear();
        }
    }

    public void write(SWFTagTypes tagwriter) throws IOException {
        this.definedSymbols.clear();
        this.maxId = 1;
        tagwriter.header(this.version, -1L, this.width * 20, this.height * 20, this.frameRate, -1);
        if (this.backColor == null) {
            this.backColor = new Color(255, 255, 255);
        }
        tagwriter.tagSetBackgroundColor(this.backColor);
        if (this.isProtected) {
            tagwriter.tagProtect(null);
        }
        if (this.importLibraries != null && !this.importLibraries.isEmpty()) {
            for (String libName : this.importLibraries.keySet()) {
                List imports = (List)this.importLibraries.get(libName);
                String[] names = new String[imports.size()];
                int[] ids = new int[imports.size()];
                int i = 0;
                for (ImportedSymbol imp : imports) {
                    names[i] = imp.getName();
                    ids[i] = imp.define(this, tagwriter, tagwriter);
                    ++i;
                }
                tagwriter.tagImport(libName, names, ids);
            }
        }
        if (this.exportedSymbols != null && !this.exportedSymbols.isEmpty()) {
            String[] names = new String[this.exportedSymbols.size()];
            int[] ids = new int[this.exportedSymbols.size()];
            int i = 0;
            for (ExportedSymbol exp : this.exportedSymbols) {
                names[i] = exp.getExportName();
                ids[i] = exp.getSymbol().define(this, tagwriter, tagwriter);
                ++i;
            }
            tagwriter.tagExport(names, ids);
        }
        int lastFrame = 0;
        for (Frame frame : this.frames.values()) {
            int number = frame.getFrameNumber();
            while (number > lastFrame + 1) {
                tagwriter.tagShowFrame();
                ++lastFrame;
            }
            frame.write(this, tagwriter, tagwriter);
            lastFrame = number;
        }
        tagwriter.tagEnd();
    }

    public void write(String filename) throws IOException {
        this.write(filename, false);
    }

    public void write(OutputStream out) throws IOException {
        this.write(out, false);
    }

    public void write(String filename, boolean compressed) throws IOException {
        SWFWriter swfwriter = new SWFWriter(filename);
        TagWriter tagwriter = new TagWriter(swfwriter);
        swfwriter.setCompression(compressed);
        this.write(tagwriter);
    }

    public void write(OutputStream out, boolean compressed) throws IOException {
        SWFWriter swfwriter = new SWFWriter(out);
        TagWriter tagwriter = new TagWriter(swfwriter);
        swfwriter.setCompression(compressed);
        this.write(tagwriter);
    }
}

