/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.validation.adapters;

import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import org.netbeans.api.validation.adapters.DialogDescriptorAdapter;
import org.netbeans.validation.api.ui.ValidationUI;
import org.netbeans.validation.api.ui.swing.SwingValidationGroup;
import org.netbeans.validation.api.ui.swing.ValidationPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class DialogBuilder {
    private String token;
    private String title;
    private boolean modal = true;
    private Object[] options;
    private Object defaultOption;
    private DialogType dialogType = DialogType.PLAIN;
    private Object message;
    private Object[] additionalOptions;
    private HelpCtx ctx;
    private ButtonSet optionType;
    private ActionListener al;
    private Object[] closingOptions;
    private SwingValidationGroup validationGroup;

    public DialogBuilder(Class<?> clazz) {
        this(clazz.getName());
    }

    public DialogBuilder(String token) {
        this.token = token;
    }

    public DialogBuilder setModal(boolean modal) {
        this.modal = modal;
        return this;
    }

    public DialogBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    public DialogBuilder setOptions(Object ... options) {
        this.options = options;
        if (this.optionType != null) {
            throw new IllegalStateException("Call setOptions, or setOptionType, not both.They are mutually exclusive");
        }
        return this;
    }

    public DialogBuilder setDefaultButton(Object defaultOption) {
        this.defaultOption = defaultOption;
        return this;
    }

    public DialogBuilder setDialogType(DialogType type) {
        this.dialogType = type;
        return this;
    }

    public DialogBuilder setContent(Object message) {
        this.message = message;
        return this;
    }

    public DialogBuilder setHelpContext(HelpCtx ctx) {
        this.ctx = ctx;
        return this;
    }

    public DialogBuilder setAdditionalButtons(Object[] additionalOptions) {
        this.additionalOptions = additionalOptions;
        return this;
    }

    public DialogBuilder setButtonSet(ButtonSet optionType) {
        this.optionType = optionType;
        if (this.options != null) {
            throw new IllegalStateException("Use setButtons or setButtonSet, not both");
        }
        return this;
    }

    public DialogBuilder setActionListener(ActionListener al) {
        this.al = al;
        return this;
    }

    public DialogBuilder setClosingOptions(Object ... options) {
        this.closingOptions = options;
        return this;
    }

    public DialogBuilder setValidationGroup(SwingValidationGroup group) {
        this.validationGroup = group;
        return this;
    }

    public boolean showDialog(Object okResult) {
        return okResult.equals(this.showDialog());
    }

    public Object showDialog() {
        DialogDescriptor des = this.createDialogDescriptor();
        Object dlgResult = DialogDisplayer.getDefault().notify((NotifyDescriptor)des);
        if (DialogDescriptor.YES_OPTION.equals(dlgResult) || DialogDescriptor.OK_OPTION.equals(dlgResult) || this.defaultOption != null && this.defaultOption.equals(dlgResult) || NbBundle.getMessage(DialogBuilder.class, (String)"BTN_CLOSE").equals(dlgResult)) {
            // empty if block
        }
        return dlgResult;
    }

    private ValidationPanel createValidationPanel(Object msg, DialogDescriptor des) {
        ValidationPanel result = this.validationGroup == null ? new ValidationPanel() : new ValidationPanel(this.validationGroup);
        result.setDelegateValidationUI((ValidationUI)new DialogDescriptorAdapter(des));
        if (msg instanceof Component) {
            result.setInnerComponent((Component)msg);
        } else {
            result.setInnerComponent((Component)new JLabel(msg.toString()));
        }
        return result;
    }

    private DialogDescriptor createDialogDescriptor() {
        if (this.message == null) {
            throw new IllegalStateException("Message not set");
        }
        Object msg = this.message;
        DialogDescriptor dlg = new DialogDescriptor(msg, this.title);
        if (this.validationGroup != null) {
            msg = this.createValidationPanel(msg, dlg);
            dlg.setMessage(msg);
        }
        if (msg instanceof ValidationPanel) {
            DialogDescriptorAdapter adap = new DialogDescriptorAdapter(dlg);
            ((ValidationPanel)msg).setDelegateValidationUI((ValidationUI)adap);
        }
        dlg.setModal(this.modal);
        dlg.setHelpCtx(this.ctx == null ? HelpCtx.DEFAULT_HELP : this.ctx);
        if (this.additionalOptions != null) {
            dlg.setAdditionalOptions(this.options);
        }
        if (this.optionType != null) {
            if (this.optionType != ButtonSet.CLOSE) {
                dlg.setOptionType(this.optionType.getDialogDisplayerConstant());
            } else {
                dlg.setOptions(new Object[]{NbBundle.getMessage(DialogBuilder.class, (String)"BTN_CLOSE")});
            }
        } else if (this.options == null) {
            dlg.setOptionType(ButtonSet.OK_CANCEL.getDialogDisplayerConstant());
        } else if (this.options != null) {
            dlg.setOptions(this.options);
        }
        if (this.al != null) {
            dlg.setButtonListener(this.al);
        }
        if (this.closingOptions != null) {
            dlg.setClosingOptions(this.options);
        }
        dlg.setMessageType(this.dialogType.getDialogDisplayerConstant());
        return dlg;
    }

    public static enum ButtonSet {
        OK_CANCEL,
        YES_NO,
        YES_NO_CANCEL,
        CLOSE;


        private int getDialogDisplayerConstant() {
            switch (this) {
                case OK_CANCEL: {
                    return 2;
                }
                case YES_NO: {
                    return 0;
                }
                case YES_NO_CANCEL: {
                    return 1;
                }
                case CLOSE: {
                    return -1;
                }
            }
            throw new AssertionError();
        }
    }

    public static enum DialogType {
        WARNING,
        INFO,
        QUESTION,
        PLAIN,
        ERROR;


        int getDialogDisplayerConstant() {
            switch (this) {
                case WARNING: {
                    return 2;
                }
                case INFO: {
                    return 1;
                }
                case QUESTION: {
                    return 3;
                }
                case PLAIN: {
                    return -1;
                }
                case ERROR: {
                    return 0;
                }
            }
            throw new AssertionError();
        }
    }
}

