/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectFactory;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.queries.AbstractMavenForBinaryQueryImpl;
import org.netbeans.modules.maven.queries.MavenFileOwnerQueryImpl;
import org.netbeans.modules.maven.queries.SourceJavadocByHash;
import org.netbeans.modules.maven.spi.queries.ForeignClassBundler;
import org.netbeans.spi.java.project.support.JavadocAndSourceRootDetection;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation2;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class RepositoryForBinaryQueryImpl
extends AbstractMavenForBinaryQueryImpl {
    private final Map<URL, WeakReference<SrcResult>> srcCache = Collections.synchronizedMap(new HashMap());
    private final Map<URL, WeakReference<JavadocResult>> javadocCache = Collections.synchronizedMap(new HashMap());
    private final Map<File, List<Coordinates>> coorCache = Collections.synchronizedMap(new HashMap());
    private static final String CLASSIFIER_TESTS = "tests";
    private static final RequestProcessor RP = new RequestProcessor("Maven Repository SFBQ result change");
    private static final Logger LOG = Logger.getLogger(SrcResult.class.getName());
    private final FileChangeAdapter binaryChangeListener = new FileChangeAdapter(){

        public void fileDataCreated(FileEvent fe) {
            this.removeCoordinates(fe);
        }

        public void fileChanged(FileEvent fe) {
            this.removeCoordinates(fe);
        }

        public void fileDeleted(FileEvent fe) {
            this.removeCoordinates(fe);
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.removeCoordinates((FileEvent)fe);
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
            this.removeCoordinates((FileEvent)fe);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeCoordinates(FileEvent fe) {
            File file = FileUtil.toFile((FileObject)fe.getFile());
            if (file != null) {
                Map map = RepositoryForBinaryQueryImpl.this.coorCache;
                synchronized (map) {
                    if (RepositoryForBinaryQueryImpl.this.coorCache.remove(file) != null) {
                        FileUtil.removeFileChangeListener((FileChangeListener)RepositoryForBinaryQueryImpl.this.binaryChangeListener, (File)file);
                    }
                }
            }
        }
    };

    public synchronized SourceForBinaryQueryImplementation2.Result findSourceRoots2(URL url) {
        SrcResult result;
        if (!"jar".equals(url.getProtocol())) {
            return null;
        }
        WeakReference<SrcResult> cached = this.srcCache.get(url);
        if (cached != null && (result = (SrcResult)cached.get()) != null) {
            return result;
        }
        if (!NbMavenProjectFactory.isAtLeastOneMavenProjectAround() && !EmbedderFactory.isProjectEmbedderLoaded()) {
            return null;
        }
        File jarFile = FileUtil.archiveOrDirForURL((URL)url);
        if (jarFile != null) {
            File[] f2;
            File parentParent;
            File parent = jarFile.getParentFile();
            if (parent != null && (parentParent = parent.getParentFile()) != null) {
                String groupId;
                URI localRepo;
                URI rel;
                String artifact = parentParent.getName();
                String version = parent.getName();
                String start = artifact + "-" + version;
                if (jarFile.getName().startsWith(start) && !(rel = (localRepo = Utilities.toURI((File)EmbedderFactory.getProjectEmbedder().getLocalRepositoryFile())).relativize(Utilities.toURI((File)parentParent.getParentFile()))).isAbsolute() && (groupId = rel.getPath()) != null && !groupId.equals("")) {
                    String end;
                    if ((groupId = groupId.replace("/", ".")).endsWith(".")) {
                        groupId = groupId.substring(0, groupId.length() - 1);
                    }
                    String classifier = null;
                    if (jarFile.getName().startsWith(start + "-") && (end = jarFile.getName().substring((start + "-").length())).indexOf(46) > -1) {
                        classifier = end.substring(0, end.indexOf(46));
                    }
                    File srcs = new File(parent, start + (classifier != null ? "-" + (CLASSIFIER_TESTS.equals(classifier) ? "test" : classifier) : "") + "-sources.jar");
                    SrcResult result2 = new SrcResult(groupId, artifact, version, classifier, FileUtil.getArchiveFile((URL)url), srcs, f -> this.getJarMetadataCoordinatesIntern((File)f));
                    this.srcCache.put(url, new WeakReference<SrcResult>(result2));
                    return result2;
                }
            }
            if ((f2 = SourceJavadocByHash.find(url, false)) != null && f2.length > 0) {
                SrcResult result3 = new SrcResult(null, null, null, null, FileUtil.getArchiveFile((URL)url), null, file -> this.getJarMetadataCoordinatesIntern((File)file));
                this.srcCache.put(url, new WeakReference<SrcResult>(result3));
                return result3;
            }
        }
        return null;
    }

    public JavadocForBinaryQuery.Result findJavadoc(URL url) {
        JavadocResult result;
        if (!"jar".equals(url.getProtocol())) {
            return null;
        }
        URL binRoot = FileUtil.getArchiveFile((URL)url);
        if (binRoot.getPath().endsWith("/javax/javaee-api/7.0/javaee-api-7.0.jar") || binRoot.getPath().endsWith("/javax/javaee-api/6.0/javaee-api-6.0.jar") || binRoot.getPath().endsWith("/javax/javaee-web-api/7.0/javaee-web-api-7.0.jar") || binRoot.getPath().endsWith("/javax/javaee-web-api/6.0/javaee-web-api-6.0.jar") || binRoot.getPath().endsWith("javax.persistence-2.1.0.jar") || binRoot.getPath().endsWith("javax.persistence-2.0.0.jar")) {
            return new JavaEEJavadocResult();
        }
        WeakReference<JavadocResult> cached = this.javadocCache.get(url);
        if (cached != null && (result = (JavadocResult)cached.get()) != null) {
            return result;
        }
        File jarFile = FileUtil.archiveOrDirForURL((URL)url);
        if (jarFile != null) {
            File[] f2;
            File parentParent;
            File parent = jarFile.getParentFile();
            if (parent != null && (parentParent = parent.getParentFile()) != null) {
                String groupId;
                URI localRepo;
                URI rel;
                String artifact = parentParent.getName();
                String version = parent.getName();
                String start = artifact + "-" + version;
                if (jarFile.getName().startsWith(start) && !(rel = (localRepo = Utilities.toURI((File)EmbedderFactory.getProjectEmbedder().getLocalRepositoryFile())).relativize(Utilities.toURI((File)parentParent.getParentFile()))).isAbsolute() && (groupId = rel.getPath()) != null && !groupId.equals("")) {
                    String end;
                    if ((groupId = groupId.replace("/", ".")).endsWith(".")) {
                        groupId = groupId.substring(0, groupId.length() - 1);
                    }
                    String classifier = null;
                    if (jarFile.getName().startsWith(start + "-") && (end = jarFile.getName().substring((start + "-").length())).indexOf(46) > -1) {
                        classifier = end.substring(0, end.indexOf(46));
                    }
                    File javadoc = new File(parent, start + (classifier != null ? "-" + (CLASSIFIER_TESTS.equals(classifier) ? "test" : classifier) : "") + "-javadoc.jar");
                    JavadocResult result2 = new JavadocResult(groupId, artifact, version, classifier, binRoot, javadoc, f -> this.getJarMetadataCoordinatesIntern((File)f));
                    this.javadocCache.put(url, new WeakReference<JavadocResult>(result2));
                    return result2;
                }
            }
            if ((f2 = SourceJavadocByHash.find(url, true)) != null && f2.length > 0) {
                JavadocResult result3 = new JavadocResult(null, null, null, null, binRoot, null, file -> this.getJarMetadataCoordinatesIntern((File)file));
                this.javadocCache.put(url, new WeakReference<JavadocResult>(result3));
                return result3;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Coordinates> getJarMetadataCoordinatesIntern(File binaryFile) {
        if (binaryFile == null || !binaryFile.exists() || !binaryFile.isFile()) {
            return null;
        }
        Map<File, List<Coordinates>> map = this.coorCache;
        synchronized (map) {
            List<Coordinates> toRet = this.coorCache.get(binaryFile);
            if (toRet == null && (toRet = RepositoryForBinaryQueryImpl.getJarMetadataCoordinates(binaryFile)) != null) {
                FileUtil.addFileChangeListener((FileChangeListener)this.binaryChangeListener, (File)binaryFile);
                this.coorCache.put(binaryFile, toRet);
            }
            return toRet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Coordinates> getJarMetadataCoordinates(File binaryFile) {
        if (binaryFile == null || !binaryFile.exists() || !binaryFile.isFile()) {
            return null;
        }
        ZipFile zip = null;
        try {
            ArrayList<Coordinates> toRet = new ArrayList<Coordinates>();
            zip = new ZipFile(binaryFile);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry ent = entries.nextElement();
                String name = ent.getName();
                if (!name.startsWith("META-INF") || !name.endsWith("pom.properties")) continue;
                Properties p = new Properties();
                p.load(zip.getInputStream(ent));
                String groupId = p.getProperty("groupId");
                String artifactId = p.getProperty("artifactId");
                String version = p.getProperty("version");
                if (groupId == null || artifactId == null || version == null) continue;
                toRet.add(new Coordinates(groupId, artifactId, version));
            }
            if (toRet.size() > 0) {
                ArrayList<Coordinates> arrayList = toRet;
                return arrayList;
            }
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "error while examining binary " + binaryFile, ex);
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private static class JavaEEJavadocResult
    implements JavadocForBinaryQuery.Result {
        private JavaEEJavadocResult() {
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }

        public URL[] getRoots() {
            try {
                File j2eeDoc = InstalledFileLocator.getDefault().locate("docs/javaee-doc-api.jar", "org.netbeans.modules.j2ee.platform", false);
                if (j2eeDoc != null) {
                    URL url = FileUtil.getArchiveRoot((URL)Utilities.toURI((File)j2eeDoc).toURL());
                    url = new URL(url + "docs/api/");
                    return new URL[]{url};
                }
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return new URL[0];
        }
    }

    private static class JavadocResult
    implements JavadocForBinaryQuery.Result {
        private final File javadocJarFile;
        private final File fallbackJavadocJarFile;
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final String classifier;
        private final URL binary;
        private final String gav;
        private final ChangeSupport support;
        private final PropertyChangeListener projectListener;
        private final FileChangeAdapter javadocJarChangeListener;
        private Project currentProject;
        private URL[] cached;
        private static final String ATTR_PATH = "lastRootCheckPath";
        private static final String ATTR_STAMP = "lastRootCheckStamp";
        private final ChangeListener mfoListener;
        private final Function<File, List<Coordinates>> coorProvider;

        JavadocResult(@NullAllowed String groupId, @NullAllowed String artifactId, @NullAllowed String version, @NullAllowed String classifier, @NonNull URL binary, @NullAllowed File javadocJar, @NonNull Function<File, List<Coordinates>> coorProvider) {
            this.javadocJarFile = javadocJar;
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.binary = binary;
            this.classifier = classifier;
            this.gav = MavenFileOwnerQueryImpl.cacheKey(groupId, artifactId, version);
            this.coorProvider = coorProvider;
            this.support = new ChangeSupport((Object)this);
            this.mfoListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    this.checkChanges();
                }
            };
            this.projectListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    if ("MavenProject".equals(event.getPropertyName())) {
                        this.checkChanges();
                    }
                }
            };
            this.javadocJarChangeListener = new FileChangeAdapter(){

                public void fileDataCreated(FileEvent fe) {
                    this.checkChanges();
                }
            };
            MavenFileOwnerQueryImpl.getInstance().addChangeListener((ChangeListener)WeakListeners.create(ChangeListener.class, (EventListener)this.mfoListener, (Object)MavenFileOwnerQueryImpl.getInstance()));
            if (this.javadocJarFile != null) {
                FileUtil.addFileChangeListener((FileChangeListener)this.javadocJarChangeListener, (File)this.javadocJarFile);
                if (classifier != null) {
                    String regularJavadoc = artifactId + "-" + version + "-javadoc.jar";
                    if (!this.javadocJarFile.getName().equals(regularJavadoc)) {
                        this.fallbackJavadocJarFile = new File(this.javadocJarFile.getParentFile(), regularJavadoc);
                        FileUtil.addFileChangeListener((FileChangeListener)this.javadocJarChangeListener, (File)this.fallbackJavadocJarFile);
                        return;
                    }
                }
            }
            this.fallbackJavadocJarFile = null;
        }

        public synchronized URL[] getRoots() {
            Object[] toRet;
            this.checkCurrentProject();
            Project prj = this.currentProject;
            if (prj != null) {
                toRet = new URL[]{};
            } else {
                URL root = FileUtil.isArchiveFile((URL)this.binary) ? FileUtil.getArchiveRoot((URL)this.binary) : this.binary;
                File[] f = SourceJavadocByHash.find(root, true);
                if (f != null) {
                    ArrayList<URL> accum = new ArrayList<URL>();
                    for (File ff : f) {
                        URL[] url = this.getJavadocJarRoot(ff);
                        if (url == null) continue;
                        accum.addAll(Arrays.asList(url));
                    }
                    toRet = accum.toArray(new URL[0]);
                } else {
                    toRet = this.javadocJarFile != null && this.javadocJarFile.exists() ? this.getJavadocJarRoot(this.javadocJarFile) : (this.fallbackJavadocJarFile != null && this.fallbackJavadocJarFile.exists() ? this.getJavadocJarRoot(this.fallbackJavadocJarFile) : this.checkShadedMultiJars());
                }
            }
            if (!Arrays.equals(this.cached, toRet)) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        support.fireChange();
                    }
                });
            }
            this.cached = toRet;
            return toRet;
        }

        public void addChangeListener(ChangeListener l) {
            this.support.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.support.removeChangeListener(l);
        }

        private void checkChanges() {
            this.getRoots();
        }

        private void checkCurrentProject() {
            Object owner = null;
            if (this.groupId != null && this.artifactId != null && this.version != null) {
                owner = MavenFileOwnerQueryImpl.getInstance().getOwner(this.groupId, this.artifactId, this.version);
            }
            if (owner != null && owner.getLookup().lookup(NbMavenProject.class) == null) {
                owner = null;
            }
            if (this.currentProject != null && !this.currentProject.equals(owner)) {
                ((NbMavenProject)this.currentProject.getLookup().lookup(NbMavenProject.class)).removePropertyChangeListener(this.projectListener);
            }
            if (owner != null && !owner.equals(this.currentProject)) {
                ((NbMavenProject)owner.getLookup().lookup(NbMavenProject.class)).addPropertyChangeListener(this.projectListener);
            }
            this.currentProject = owner;
        }

        private URL[] getJavadocJarRoot(File file) {
            try {
                if (file.exists()) {
                    URL[] url;
                    FileObject fo = FileUtil.toFileObject((File)file);
                    if (!FileUtil.isArchiveFile((FileObject)fo)) {
                        Logger.getLogger(RepositoryForBinaryQueryImpl.class.getName()).log(Level.INFO, "javadoc in repository is not really a JAR: {0}", file);
                        return new URL[0];
                    }
                    Date date = (Date)fo.getAttribute(ATTR_STAMP);
                    String path = (String)fo.getAttribute(ATTR_PATH);
                    if (date == null || fo.lastModified().after(date)) {
                        path = this.checkPath(FileUtil.getArchiveRoot((FileObject)fo), fo);
                    }
                    if (path != null) {
                        url = new URL[1];
                        URL root = FileUtil.getArchiveRoot((URL)Utilities.toURI((File)file).toURL());
                        if (!path.endsWith("/")) {
                            path = path + "/";
                        }
                        url[0] = new URL(root, path);
                    } else {
                        url = new URL[]{FileUtil.getArchiveRoot((URL)Utilities.toURI((File)file).toURL())};
                    }
                    return url;
                }
            }
            catch (MalformedURLException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
            }
            return new URL[0];
        }

        private String checkPath(FileObject jarRoot, FileObject fo) {
            String toRet = null;
            FileObject root = JavadocAndSourceRootDetection.findJavadocRoot((FileObject)jarRoot);
            try {
                if (root != null && !root.equals(jarRoot)) {
                    toRet = FileUtil.getRelativePath((FileObject)jarRoot, (FileObject)root);
                    fo.setAttribute(ATTR_PATH, (Object)toRet);
                }
                fo.setAttribute(ATTR_STAMP, (Object)new Date());
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return toRet;
        }

        private synchronized URL[] checkShadedMultiJars() {
            try {
                List<Coordinates> coordinates = this.coorProvider.apply(Utilities.toFile((URI)this.binary.toURI()));
                File lrf = EmbedderFactory.getProjectEmbedder().getLocalRepositoryFile();
                ArrayList<URL> urls = new ArrayList<URL>();
                if (coordinates != null) {
                    for (Coordinates coord : coordinates) {
                        File javadocJar = new File(lrf, coord.groupId.replace(".", File.separator) + File.separator + coord.artifactId + File.separator + coord.version + File.separator + coord.artifactId + "-" + coord.version + "-javadoc.jar");
                        URL[] fo = this.getJavadocJarRoot(javadocJar);
                        if (fo.length != 1) continue;
                        urls.add(fo[0]);
                    }
                }
                if (urls.size() > 1) {
                    URL[] shaded = urls.toArray(new URL[0]);
                    return shaded;
                }
            }
            catch (Exception ex) {
                LOG.log(Level.INFO, "error while examining binary " + this.binary, ex);
            }
            return new URL[0];
        }
    }

    public static class Coordinates {
        public final String groupId;
        public final String artifactId;
        public final String version;

        private Coordinates(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }
    }

    private static class SrcResult
    implements SourceForBinaryQueryImplementation2.Result {
        private static final String ATTR_PATH = "lastRootCheckPath";
        private static final String ATTR_STAMP = "lastRootCheckStamp";
        private final File sourceJarFile;
        private final File fallbackSourceJarFile;
        private final ChangeSupport support;
        private final ChangeListener mfoListener;
        private final PropertyChangeListener projectListener;
        private final FileChangeListener sourceJarChangeListener;
        private final RequestProcessor.Task checkChangesTask;
        private static final int CHECK_CHANGES_DELAY = 50;
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final String classifier;
        private final URL binary;
        private Project currentProject;
        private FileObject[] cached;
        private Boolean cachedPreferedSources;
        private boolean avoidScheduling = false;
        private final AtomicBoolean needsFiring = new AtomicBoolean(false);
        private final Function<File, List<Coordinates>> coorProvider;

        SrcResult(@NullAllowed String groupId, @NullAllowed String artifactId, @NullAllowed String version, @NullAllowed String classifier, @NonNull URL binary, @NullAllowed File sourceJar, Function<File, List<Coordinates>> coorProvider) {
            this.sourceJarFile = sourceJar;
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.binary = binary;
            this.classifier = classifier;
            this.coorProvider = coorProvider;
            this.support = new ChangeSupport((Object)this);
            this.checkChangesTask = RP.create(new Runnable(){

                @Override
                public void run() {
                    this.checkChanges(true);
                }
            });
            this.mfoListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (e instanceof MavenFileOwnerQueryImpl.GAVCHangeEvent) {
                        MavenFileOwnerQueryImpl.GAVCHangeEvent gav = (MavenFileOwnerQueryImpl.GAVCHangeEvent)e;
                        if (gav.getGroupId().equals(groupId) && gav.getArtifactId().equals(artifactId) && gav.getVersion().equals(version)) {
                            checkChangesTask.schedule(50);
                        }
                    } else {
                        checkChangesTask.schedule(50);
                    }
                }
            };
            this.projectListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    if ("MavenProject".equals(event.getPropertyName())) {
                        checkChangesTask.schedule(50);
                    }
                }
            };
            this.sourceJarChangeListener = new FileChangeAdapter(){

                public void fileDataCreated(FileEvent fe) {
                    checkChangesTask.schedule(50);
                }
            };
            this.checkChanges(false);
            MavenFileOwnerQueryImpl.getInstance().addChangeListener((ChangeListener)WeakListeners.create(ChangeListener.class, (EventListener)this.mfoListener, (Object)MavenFileOwnerQueryImpl.getInstance()));
            if (this.sourceJarFile != null) {
                FileUtil.addFileChangeListener((FileChangeListener)FileUtil.weakFileChangeListener((FileChangeListener)this.sourceJarChangeListener, null));
                if (classifier != null) {
                    String regularSources = artifactId + "-" + version + "-sources.jar";
                    if (!this.sourceJarFile.getName().equals(regularSources)) {
                        this.fallbackSourceJarFile = new File(this.sourceJarFile.getParentFile(), regularSources);
                        return;
                    }
                }
            }
            this.fallbackSourceJarFile = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkChanges(boolean fireChanges) {
            Object owner = null;
            if (this.groupId != null && this.artifactId != null && this.version != null && (owner = MavenFileOwnerQueryImpl.getInstance().getOwner(this.groupId, this.artifactId, this.version)) != null && owner.getLookup().lookup(NbMavenProject.class) == null) {
                owner = null;
            }
            SrcResult srcResult = this;
            synchronized (srcResult) {
                if (this.currentProject != null && !this.currentProject.equals(owner)) {
                    ((NbMavenProject)this.currentProject.getLookup().lookup(NbMavenProject.class)).removePropertyChangeListener(this.projectListener);
                }
                if (owner != null && !owner.equals(this.currentProject)) {
                    ((NbMavenProject)owner.getLookup().lookup(NbMavenProject.class)).addPropertyChangeListener(this.projectListener);
                }
                this.currentProject = owner;
                if (fireChanges && !this.needsFiring.get()) {
                    this.avoidScheduling = true;
                    try {
                        this.getRoots();
                        this.preferSources();
                    }
                    finally {
                        this.avoidScheduling = false;
                    }
                }
            }
            if (fireChanges && this.needsFiring.get()) {
                this.support.fireChange();
            }
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.support.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.support.removeChangeListener(changeListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject[] getRoots() {
            Object[] toRet;
            Project prj;
            SrcResult srcResult = this;
            synchronized (srcResult) {
                prj = this.currentProject;
            }
            if (prj != null && this.classifier == null) {
                toRet = AbstractMavenForBinaryQueryImpl.getProjectSrcRoots(prj);
            } else if (prj != null && RepositoryForBinaryQueryImpl.CLASSIFIER_TESTS.equals(this.classifier)) {
                toRet = AbstractMavenForBinaryQueryImpl.getProjectTestSrcRoots(prj);
            } else {
                URL root = FileUtil.isArchiveFile((URL)this.binary) ? FileUtil.getArchiveRoot((URL)this.binary) : this.binary;
                File[] f = SourceJavadocByHash.find(root, false);
                if (f != null) {
                    ArrayList<FileObject> accum = new ArrayList<FileObject>();
                    for (File ff : f) {
                        accum.addAll(Arrays.asList(SrcResult.getSourceJarRoot(ff)));
                    }
                    toRet = accum.toArray(new FileObject[0]);
                } else {
                    ArrayList<FileObject> fos = new ArrayList<FileObject>();
                    if (prj != null) {
                        this.add(fos, AbstractMavenForBinaryQueryImpl.getProjectSrcRoots(prj));
                    }
                    if (this.sourceJarFile != null && this.sourceJarFile.exists()) {
                        this.add(fos, SrcResult.getSourceJarRoot(this.sourceJarFile));
                    } else if (this.fallbackSourceJarFile != null && this.fallbackSourceJarFile.exists()) {
                        this.add(fos, SrcResult.getSourceJarRoot(this.fallbackSourceJarFile));
                    }
                    this.add(fos, this.getShadedJarSources());
                    toRet = fos.toArray(new FileObject[0]);
                }
            }
            srcResult = this;
            synchronized (srcResult) {
                if (this.cached != null && !Arrays.equals(this.cached, toRet) && this.needsFiring.compareAndSet(false, true) && !this.avoidScheduling) {
                    this.checkChangesTask.schedule(50);
                }
                this.cached = toRet;
            }
            return toRet;
        }

        private void add(List<FileObject> to, FileObject[] add) {
            for (FileObject a : add) {
                if (to.contains(a)) continue;
                to.add(a);
            }
        }

        private static String checkPath(FileObject jarRoot, FileObject fo) {
            String toRet = null;
            FileObject root = JavadocAndSourceRootDetection.findSourceRoot((FileObject)jarRoot);
            try {
                if (root != null && !root.equals(jarRoot)) {
                    toRet = FileUtil.getRelativePath((FileObject)jarRoot, (FileObject)root);
                    fo.setAttribute(ATTR_PATH, (Object)toRet);
                }
                fo.setAttribute(ATTR_STAMP, (Object)new Date());
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return toRet;
        }

        @NonNull
        private static FileObject[] getSourceJarRoot(File sourceJar) {
            FileObject jarRoot;
            FileObject fo = FileUtil.toFileObject((File)sourceJar);
            if (fo != null && (jarRoot = FileUtil.getArchiveRoot((FileObject)fo)) != null) {
                Date date = (Date)fo.getAttribute(ATTR_STAMP);
                String path = (String)fo.getAttribute(ATTR_PATH);
                if (date == null || fo.lastModified().after(date)) {
                    path = SrcResult.checkPath(jarRoot, fo);
                }
                FileObject[] fos = new FileObject[1];
                if (path != null) {
                    fos[0] = jarRoot.getFileObject(path);
                }
                if (fos[0] == null) {
                    fos[0] = jarRoot;
                }
                return fos;
            }
            return new FileObject[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean preferSources() {
            Project prj;
            boolean toRet = false;
            SrcResult srcResult = this;
            synchronized (srcResult) {
                prj = this.currentProject;
            }
            if (prj != null && this.classifier == null) {
                if (!NbMavenProject.isErrorPlaceholder(((NbMavenProject)prj.getLookup().lookup(NbMavenProject.class)).getMavenProject())) {
                    toRet = ((ForeignClassBundler)prj.getLookup().lookup(ForeignClassBundler.class)).preferSources();
                }
            } else if (prj != null && RepositoryForBinaryQueryImpl.CLASSIFIER_TESTS.equals(this.classifier)) {
                toRet = true;
            }
            srcResult = this;
            synchronized (srcResult) {
                if (this.cachedPreferedSources != null && !this.cachedPreferedSources.equals(toRet) && this.needsFiring.compareAndSet(false, true) && !this.avoidScheduling) {
                    this.checkChangesTask.schedule(50);
                }
                this.cachedPreferedSources = toRet;
            }
            return toRet;
        }

        @NonNull
        private synchronized FileObject[] getShadedJarSources() {
            try {
                List<Coordinates> coordinates = this.coorProvider.apply(Utilities.toFile((URI)this.binary.toURI()));
                File lrf = EmbedderFactory.getProjectEmbedder().getLocalRepositoryFile();
                ArrayList<FileObject> fos = new ArrayList<FileObject>();
                if (coordinates != null) {
                    for (Coordinates coord : coordinates) {
                        if (coord.artifactId.equals(this.artifactId) && coord.groupId.equals(this.groupId) && coord.version.equals(this.version)) continue;
                        File sourceJar = new File(lrf, coord.groupId.replace(".", File.separator) + File.separator + coord.artifactId + File.separator + coord.version + File.separator + coord.artifactId + "-" + coord.version + "-sources.jar");
                        fos.addAll(Arrays.asList(SrcResult.getSourceJarRoot(sourceJar)));
                    }
                }
                return fos.toArray(new FileObject[0]);
            }
            catch (Exception ex) {
                LOG.log(Level.INFO, "error while examining binary " + this.binary, ex);
                return new FileObject[0];
            }
        }
    }
}

