/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer;

import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.maven.index.ArtifactAvailability;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.creator.MinimalArtifactInfoIndexCreator;

final class MinimalArtifactInfoRemoteIndexCreator
extends MinimalArtifactInfoIndexCreator {
    private static final char FS = "|".charAt(0);

    MinimalArtifactInfoRemoteIndexCreator() {
    }

    public void updateDocument(ArtifactInfo ai, Document doc) {
        String info = ArtifactInfo.nvl((String)ai.getPackaging()) + "|" + ai.getLastModified() + "|" + ai.getSize() + "|" + ai.getSourcesExists().toString() + "|" + ai.getJavadocExists().toString() + "|" + ai.getSignatureExists().toString() + "|" + ai.getFileExtension();
        doc.add((IndexableField)FLD_INFO.toField(info));
        doc.add((IndexableField)FLD_GROUP_ID_KW.toField(ai.getGroupId()));
        doc.add((IndexableField)FLD_ARTIFACT_ID_KW.toField(ai.getArtifactId()));
        doc.add((IndexableField)FLD_VERSION_KW.toField(ai.getVersion()));
        doc.add((IndexableField)FLD_GROUP_ID.toField(ai.getGroupId()));
        doc.add((IndexableField)FLD_ARTIFACT_ID.toField(ai.getArtifactId()));
        doc.add((IndexableField)FLD_VERSION.toField(ai.getVersion()));
        doc.add((IndexableField)FLD_EXTENSION.toField(ai.getFileExtension()));
        if (ai.getName() != null) {
            doc.add((IndexableField)FLD_NAME.toField(ai.getName()));
        }
        if (ai.getPackaging() != null) {
            doc.add((IndexableField)FLD_PACKAGING.toField(ai.getPackaging()));
        }
        if (ai.getClassifier() != null) {
            doc.add((IndexableField)FLD_CLASSIFIER.toField(ai.getClassifier()));
        }
    }

    public boolean updateArtifactInfo(Document doc, ArtifactInfo ai) {
        String name;
        String info;
        boolean res = false;
        String uinfo = doc.get(ArtifactInfo.UINFO);
        if (uinfo != null) {
            int start = 0;
            int end = uinfo.indexOf(FS);
            ai.setGroupId(uinfo.substring(start, end));
            start = end + 1;
            end = uinfo.indexOf(FS, start);
            ai.setArtifactId(uinfo.substring(start, end));
            start = end + 1;
            end = uinfo.indexOf(FS, start);
            ai.setVersion(uinfo.substring(start, end));
            start = end + 1;
            end = uinfo.indexOf(FS, start);
            if (end == -1) {
                end = uinfo.length();
            }
            ai.setClassifier(ArtifactInfo.renvl((String)uinfo.substring(start, end)));
            if (end < uinfo.length()) {
                start = end + 1;
                end = uinfo.length();
                ai.setFileExtension(uinfo.substring(start, end));
            }
            res = true;
        }
        if ((info = doc.get(ArtifactInfo.INFO)) != null) {
            int start = 0;
            int end = info.indexOf(FS);
            ai.setPackaging(ArtifactInfo.renvl((String)info.substring(start, end)));
            start = end + 1;
            end = info.indexOf(FS, start);
            ai.setLastModified(Long.parseLong(info.substring(start, end)));
            start = end + 1;
            end = info.indexOf(FS, start);
            ai.setSize(Long.parseLong(info.substring(start, end)));
            start = end + 1;
            end = info.indexOf(FS, start);
            ai.setSourcesExists(ArtifactAvailability.fromString((String)info.substring(start, end)));
            start = end + 1;
            end = info.indexOf(FS, start);
            ai.setJavadocExists(ArtifactAvailability.fromString((String)info.substring(start, end)));
            start = end + 1;
            end = info.indexOf(FS, start);
            if (end == -1) {
                end = info.length();
            }
            ai.setSignatureExists(ArtifactAvailability.fromString((String)info.substring(start, end)));
            if (end < info.length()) {
                start = end + 1;
                end = info.length();
                ai.setFileExtension(info.substring(start, end));
            } else if (ai.getClassifier() != null || "pom".equals(ai.getPackaging()) || "war".equals(ai.getPackaging()) || "ear".equals(ai.getPackaging())) {
                ai.setFileExtension(ai.getPackaging());
            } else {
                ai.setFileExtension("jar");
            }
            res = true;
        }
        if ((name = doc.get(ArtifactInfo.NAME)) != null) {
            ai.setName(name);
            res = true;
        }
        if ("null".equals(ai.getPackaging())) {
            ai.setPackaging(null);
        }
        return res;
    }

    static {
        if ("|".length() != 1) {
            throw new IllegalStateException("field format changed");
        }
    }
}

