/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.windows8;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

final class DPIUnscaledBorder
implements Border,
UIResource {
    private final Border delegate;

    public DPIUnscaledBorder(Border delegate) {
        if (delegate == null) {
            throw new NullPointerException();
        }
        this.delegate = delegate;
    }

    @Override
    public void paintBorder(Component c, Graphics g0, int x, int y, int width, int height) {
        int deviceHeight;
        int deviceWidth;
        Graphics2D g = (Graphics2D)g0;
        AffineTransform oldTransform = g.getTransform();
        g.translate(x, y);
        AffineTransform tx = g.getTransform();
        int txType = tx.getType();
        if (txType == 2 || txType == 3) {
            double scale = tx.getScaleX();
            int deviceX = (int)tx.getTranslateX();
            int deviceY = (int)tx.getTranslateY();
            int deviceXend = (int)(tx.getTranslateX() + (double)width * scale);
            int deviceYend = (int)(tx.getTranslateY() + (double)height * scale);
            deviceWidth = deviceXend - deviceX;
            deviceHeight = deviceYend - deviceY;
            g.setTransform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, deviceX, deviceY));
        } else {
            deviceWidth = width;
            deviceHeight = height;
        }
        this.delegate.paintBorder(c, g, 0, 0, deviceWidth, deviceHeight);
        g.setTransform(oldTransform);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.delegate.getBorderInsets(c);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

