/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness.internal;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import org.neo4j.annotations.api.PublicApi;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.harness.Neo4j;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.server.NeoServer;

@PublicApi
public class InProcessNeo4j
implements Neo4j {
    private final File serverFolder;
    private final File userLogFile;
    private final File internalLogFile;
    private final NeoServer server;
    private final Closeable additionalClosable;
    private ConnectorPortRegister connectorPortRegister;

    public InProcessNeo4j(File serverFolder, File userLogFile, File internalLogFile, NeoServer server, Closeable additionalClosable) {
        this.serverFolder = serverFolder;
        this.userLogFile = userLogFile;
        this.internalLogFile = internalLogFile;
        this.server = server;
        this.additionalClosable = additionalClosable;
    }

    @Override
    public URI boltURI() {
        if (((Boolean)this.server.getConfig().get(BoltConnector.enabled)).booleanValue()) {
            return this.connectorUri("bolt", "bolt");
        }
        throw new IllegalStateException("Bolt connector is not configured");
    }

    @Override
    public URI httpURI() {
        if (((Boolean)this.server.getConfig().get(HttpConnector.enabled)).booleanValue()) {
            return this.connectorUri("http", "http");
        }
        throw new IllegalStateException("HTTP connector is not configured");
    }

    @Override
    public URI httpsURI() {
        if (((Boolean)this.server.getConfig().get(HttpsConnector.enabled)).booleanValue()) {
            return this.connectorUri("https", "https");
        }
        throw new IllegalStateException("HTTPS connector is not configured");
    }

    public void start() {
        this.server.start();
        this.connectorPortRegister = InProcessNeo4j.connectorPortRegister(this.server);
    }

    @Override
    public void close() {
        this.server.stop();
        this.connectorPortRegister = null;
        try {
            this.additionalClosable.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            if (this.looksLikeMd5Hash(this.serverFolder.getName())) {
                FileUtils.deleteRecursively((File)this.serverFolder);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to clean up test server directory.", e);
        }
    }

    @Override
    public void printLogs(PrintStream out) {
        InProcessNeo4j.printLog("User Log File", this.userLogFile, out);
        InProcessNeo4j.printLog("Internal Log File", this.internalLogFile, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printLog(String description, File file, PrintStream out) {
        if (file != null && file.exists()) {
            out.println(String.format("---------- BEGIN %s ----------", description));
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                reader.lines().forEach(out::println);
            }
            catch (IOException ex) {
                try {
                    out.println("Unable to collect log files: " + ex.getMessage());
                    ex.printStackTrace(out);
                }
                catch (Throwable throwable) {
                    out.println(String.format("---------- END %s ----------", description));
                    throw throwable;
                }
                out.println(String.format("---------- END %s ----------", description));
            }
            out.println(String.format("---------- END %s ----------", description));
        }
    }

    private boolean looksLikeMd5Hash(String name) {
        return name.length() == 32;
    }

    @Override
    public DatabaseManagementService databaseManagementService() {
        return this.server.getDatabaseService().getDatabaseManagementService();
    }

    @Override
    public GraphDatabaseService defaultDatabaseService() {
        return this.server.getDatabaseService().getDatabase();
    }

    @Override
    public Configuration config() {
        return this.server.getConfig();
    }

    private URI connectorUri(String scheme, String connectorName) {
        HostnamePort hostPort = this.connectorPortRegister.getLocalAddress(connectorName);
        return URI.create(scheme + "://" + hostPort + "/");
    }

    private static ConnectorPortRegister connectorPortRegister(NeoServer server) {
        return (ConnectorPortRegister)server.getDatabaseService().getDatabase().getDependencyResolver().resolveDependency(ConnectorPortRegister.class);
    }
}

