/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness.internal;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.Optional;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.harness.ServerControls;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.configuration.ConnectorPortRegister;
import org.neo4j.server.AbstractNeoServer;

public class InProcessServerControls
implements ServerControls {
    private final File serverFolder;
    private final File userLogFile;
    private final File internalLogFile;
    private final AbstractNeoServer server;
    private final Closeable additionalClosable;
    private ConnectorPortRegister connectorPortRegister;

    public InProcessServerControls(File serverFolder, File userLogFile, File internalLogFile, AbstractNeoServer server, Closeable additionalClosable) {
        this.serverFolder = serverFolder;
        this.userLogFile = userLogFile;
        this.internalLogFile = internalLogFile;
        this.server = server;
        this.additionalClosable = additionalClosable;
    }

    @Override
    public URI boltURI() {
        HostnamePort boltHostNamePort = this.connectorPortRegister.getLocalAddress("bolt");
        return URI.create("bolt://" + boltHostNamePort.getHost() + ":" + boltHostNamePort.getPort());
    }

    @Override
    public URI httpURI() {
        return this.server.baseUri();
    }

    @Override
    public Optional<URI> httpsURI() {
        return this.server.httpsUri();
    }

    public void start() {
        this.server.start();
        this.connectorPortRegister = (ConnectorPortRegister)this.server.getDependencyResolver().resolveDependency(ConnectorPortRegister.class);
    }

    @Override
    public void close() {
        this.server.stop();
        this.connectorPortRegister = null;
        try {
            this.additionalClosable.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            if (this.looksLikeMd5Hash(this.serverFolder.getName())) {
                FileUtils.deleteRecursively((File)this.serverFolder);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to clean up test server directory.", e);
        }
    }

    @Override
    public void printLogs(PrintStream out) {
        InProcessServerControls.printLog("User Log File", this.userLogFile, out);
        InProcessServerControls.printLog("Internal Log File", this.internalLogFile, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printLog(String description, File file, PrintStream out) {
        if (file != null && file.exists()) {
            out.println(String.format("---------- BEGIN %s ----------", description));
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                reader.lines().forEach(out::println);
            }
            catch (IOException ex) {
                try {
                    out.println("Unable to collect log files: " + ex.getMessage());
                    ex.printStackTrace(out);
                }
                catch (Throwable throwable) {
                    out.println(String.format("---------- END %s ----------", description));
                    throw throwable;
                }
                out.println(String.format("---------- END %s ----------", description));
            }
            out.println(String.format("---------- END %s ----------", description));
        }
    }

    private boolean looksLikeMd5Hash(String name) {
        return name.length() == 32;
    }

    @Override
    public GraphDatabaseService graph() {
        return this.server.getDatabase().getGraph();
    }

    @Override
    public Configuration config() {
        return this.server.getConfig();
    }
}

