/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness.junit.extension;

import java.nio.file.Path;
import java.util.function.Function;
import org.neo4j.annotations.api.PublicApi;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.harness.Neo4jBuilder;
import org.neo4j.harness.Neo4jBuilders;
import org.neo4j.harness.junit.extension.Neo4jExtension;

@PublicApi
public class Neo4jExtensionBuilder {
    private Neo4jBuilder builder;

    Neo4jExtensionBuilder() {
        this(Neo4jBuilders.newInProcessBuilder());
    }

    protected Neo4jExtensionBuilder(Neo4jBuilder builder) {
        this.builder = builder;
    }

    public Neo4jExtensionBuilder withFolder(Path workingDirectory) {
        this.builder = (Neo4jBuilder)this.builder.withWorkingDir(workingDirectory);
        return this;
    }

    public <T> Neo4jExtensionBuilder withConfig(Setting<T> key, T value) {
        this.builder = (Neo4jBuilder)this.builder.withConfig(key, value);
        return this;
    }

    public Neo4jExtensionBuilder withUnmanagedExtension(String mountPath, Class<?> extension) {
        this.builder = (Neo4jBuilder)this.builder.withUnmanagedExtension(mountPath, extension);
        return this;
    }

    public Neo4jExtensionBuilder withUnmanagedExtension(String mountPath, String packageName) {
        this.builder = (Neo4jBuilder)this.builder.withUnmanagedExtension(mountPath, packageName);
        return this;
    }

    public Neo4jExtensionBuilder withDisabledServer() {
        this.builder = (Neo4jBuilder)this.builder.withDisabledServer();
        return this;
    }

    public Neo4jExtensionBuilder withFixture(Path cypherFileOrDirectory) {
        this.builder = (Neo4jBuilder)this.builder.withFixture(cypherFileOrDirectory);
        return this;
    }

    public Neo4jExtensionBuilder withFixture(String fixtureStatement) {
        this.builder = (Neo4jBuilder)this.builder.withFixture(fixtureStatement);
        return this;
    }

    public Neo4jExtensionBuilder withFixture(Function<GraphDatabaseService, Void> fixtureFunction) {
        this.builder = (Neo4jBuilder)this.builder.withFixture(fixtureFunction);
        return this;
    }

    public Neo4jExtensionBuilder copyFrom(Path sourceDirectory) {
        this.builder = (Neo4jBuilder)this.builder.copyFrom(sourceDirectory);
        return this;
    }

    public Neo4jExtensionBuilder withProcedure(Class<?> procedureClass) {
        this.builder = (Neo4jBuilder)this.builder.withProcedure(procedureClass);
        return this;
    }

    public Neo4jExtensionBuilder withFunction(Class<?> functionClass) {
        this.builder = (Neo4jBuilder)this.builder.withFunction(functionClass);
        return this;
    }

    public Neo4jExtensionBuilder withAggregationFunction(Class<?> functionClass) {
        this.builder = (Neo4jBuilder)this.builder.withAggregationFunction(functionClass);
        return this;
    }

    public Neo4jExtension build() {
        return new Neo4jExtension(this.builder);
    }
}

