/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness;

import java.util.Iterator;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.model.Statement;
import org.neo4j.function.Function;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.harness.extensionpackage.MyUnmanagedExtension;
import org.neo4j.harness.junit.Neo4jRule;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.test.SuppressOutput;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.server.HTTP;

public class JUnitRuleTest {
    @Rule
    public Neo4jRule neo4j = new Neo4jRule().withFixture("CREATE (u:User)").withFixture((Function)new Function<GraphDatabaseService, Void>(){

        public Void apply(GraphDatabaseService graphDatabaseService) throws RuntimeException {
            try (Transaction tx = graphDatabaseService.beginTx();){
                graphDatabaseService.createNode(new Label[]{DynamicLabel.label((String)"User")});
                tx.success();
            }
            return null;
        }
    }).withExtension("/test", MyUnmanagedExtension.class);
    @Rule
    public TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();

    @Test
    public void shouldExtensionWork() throws Exception {
        MatcherAssert.assertThat((Object)HTTP.GET((String)this.neo4j.httpURI().resolve("test/myExtension").toString()).status(), (Matcher)CoreMatchers.equalTo((Object)234));
    }

    @Test
    public void shouldFixturesWork() throws Exception {
        HTTP.Response response = HTTP.POST((String)(this.neo4j.httpURI().toString() + "db/data/transaction/commit"), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{'statements':[{'statement':'MATCH (n:User) RETURN n'}]}"));
        MatcherAssert.assertThat((Object)response.get("results").get(0).get("data").size(), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void shouldGraphDatabaseServiceBeAccessible() {
        Assert.assertEquals((long)2L, (long)IteratorUtil.count((Iterator)this.neo4j.getGraphDatabaseService().execute("MATCH (n:User) RETURN n")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRuleWorkWithExsitingDirectory() {
        GraphDatabaseService db = new GraphDatabaseFactory().newEmbeddedDatabase(this.testDirectory.absolutePath());
        try {
            db.execute("create ()");
        }
        finally {
            db.shutdown();
        }
        final Neo4jRule ruleWithDirectory = new Neo4jRule(this.testDirectory.directory()).copyFrom(this.testDirectory.directory());
        ruleWithDirectory.apply(new Statement(){

            public void evaluate() throws Throwable {
                Result result = ruleWithDirectory.getGraphDatabaseService().execute("match (n) return count(n) as count");
                List column = IteratorUtil.asList((Iterator)result.columnAs("count"));
                Assert.assertEquals((long)1L, (long)column.size());
                Assert.assertEquals((Object)1, column.get(0));
            }
        }, null);
    }
}

