/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness;

import java.io.File;
import junit.framework.TestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.function.Function;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.harness.ServerControls;
import org.neo4j.harness.TestServerBuilders;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.test.SuppressOutput;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.server.HTTP;

public class FixturesTest {
    @Rule
    public TargetDirectory.TestDirectory testDir = TargetDirectory.testDirForTest(FixturesTest.class);
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();

    @Test
    public void shouldAccepSingleCypherFileAsFixture() throws Exception {
        File targetFolder = this.testDir.directory();
        File fixture = new File(targetFolder, "fixture.cyp");
        FileUtils.writeToFile((File)fixture, (String)"CREATE (u:User)CREATE (a:OtherUser)", (boolean)false);
        try (ServerControls server = TestServerBuilders.newInProcessBuilder((File)targetFolder).withFixture(fixture).newServer();){
            HTTP.Response response = HTTP.POST((String)(server.httpURI().toString() + "db/data/transaction/commit"), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{'statements':[{'statement':'MATCH (n:User) RETURN n'}]}"));
            MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)response.get("results").get(0).get("data").size(), (Matcher)CoreMatchers.equalTo((Object)1));
        }
    }

    @Test
    public void shouldAcceptFolderWithCypFilesAsFixtures() throws Exception {
        File targetFolder = this.testDir.directory();
        FileUtils.writeToFile((File)new File(targetFolder, "fixture1.cyp"), (String)"CREATE (u:User)\nCREATE (a:OtherUser)", (boolean)false);
        FileUtils.writeToFile((File)new File(targetFolder, "fixture2.cyp"), (String)"CREATE (u:User)\nCREATE (a:OtherUser)", (boolean)false);
        File subDir = new File(targetFolder, "subdirectory");
        subDir.mkdir();
        FileUtils.writeToFile((File)new File(subDir, "subDirFixture.cyp"), (String)"CREATE (u:User)\nCREATE (a:OtherUser)", (boolean)false);
        try (ServerControls server = TestServerBuilders.newInProcessBuilder((File)targetFolder).withFixture(targetFolder).newServer();){
            HTTP.Response response = HTTP.POST((String)(server.httpURI().toString() + "db/data/transaction/commit"), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{'statements':[{'statement':'MATCH (n:User) RETURN n'}]}"));
            MatcherAssert.assertThat((String)response.toString(), (Object)response.get("results").get(0).get("data").size(), (Matcher)CoreMatchers.equalTo((Object)3));
        }
    }

    @Test
    public void shouldHandleMultipleFixtures() throws Exception {
        File targetFolder = this.testDir.directory();
        File fixture1 = new File(targetFolder, "fixture1.cyp");
        FileUtils.writeToFile((File)fixture1, (String)"CREATE (u:User)\nCREATE (a:OtherUser)", (boolean)false);
        File fixture2 = new File(targetFolder, "fixture2.cyp");
        FileUtils.writeToFile((File)fixture2, (String)"CREATE (u:User)\nCREATE (a:OtherUser)", (boolean)false);
        try (ServerControls server = TestServerBuilders.newInProcessBuilder((File)targetFolder).withFixture(fixture1).withFixture(fixture2).newServer();){
            HTTP.Response response = HTTP.POST((String)(server.httpURI().toString() + "db/data/transaction/commit"), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{'statements':[{'statement':'MATCH (n:User) RETURN n'}]}"));
            MatcherAssert.assertThat((Object)response.get("results").get(0).get("data").size(), (Matcher)CoreMatchers.equalTo((Object)2));
        }
    }

    @Test
    public void shouldHandleStringFixtures() throws Exception {
        File targetFolder = this.testDir.directory();
        try (ServerControls server = TestServerBuilders.newInProcessBuilder((File)targetFolder).withFixture("CREATE (a:User)").newServer();){
            HTTP.Response response = HTTP.POST((String)(server.httpURI().toString() + "db/data/transaction/commit"), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{'statements':[{'statement':'MATCH (n:User) RETURN n'}]}"));
            MatcherAssert.assertThat((Object)response.get("results").get(0).get("data").size(), (Matcher)CoreMatchers.equalTo((Object)1));
        }
    }

    @Test
    public void shouldIgnoreEmptyFixtureFiles() throws Exception {
        File targetFolder = this.testDir.directory();
        FileUtils.writeToFile((File)new File(targetFolder, "fixture1.cyp"), (String)"CREATE (u:User)\nCREATE (a:OtherUser)", (boolean)false);
        FileUtils.writeToFile((File)new File(targetFolder, "fixture2.cyp"), (String)"", (boolean)false);
        try (ServerControls server = TestServerBuilders.newInProcessBuilder((File)targetFolder).withFixture(targetFolder).newServer();){
            HTTP.Response response = HTTP.POST((String)(server.httpURI().toString() + "db/data/transaction/commit"), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{'statements':[{'statement':'MATCH (n:User) RETURN n'}]}"));
            MatcherAssert.assertThat((Object)response.get("results").get(0).get("data").size(), (Matcher)CoreMatchers.equalTo((Object)1));
        }
    }

    @Test
    public void shouldHandleFixturesWithSyntaxErrorsGracefully() throws Exception {
        File targetFolder = this.testDir.directory();
        FileUtils.writeToFile((File)new File(targetFolder, "fixture1.cyp"), (String)"this is not a valid cypher statement", (boolean)false);
        try (ServerControls ignore = TestServerBuilders.newInProcessBuilder((File)targetFolder).withFixture(targetFolder).newServer();){
            TestCase.fail((String)"Should have thrown exception");
        }
        catch (RuntimeException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Invalid input 't': expected <init> (line 1, column 1 (offset: 0))\n\"this is not a valid cypher statement\"\n ^"));
        }
    }

    @Test
    public void shouldHandleFunctionFixtures() throws Exception {
        File targetFolder = this.testDir.directory();
        try (ServerControls server = TestServerBuilders.newInProcessBuilder((File)targetFolder).withFixture((Function)new Function<GraphDatabaseService, Void>(){

            public Void apply(GraphDatabaseService graphDatabaseService) throws RuntimeException {
                try (Transaction tx = graphDatabaseService.beginTx();){
                    graphDatabaseService.createNode(new Label[]{DynamicLabel.label((String)"User")});
                    tx.success();
                }
                return null;
            }
        }).newServer();){
            HTTP.Response response = HTTP.POST((String)(server.httpURI().toString() + "db/data/transaction/commit"), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{'statements':[{'statement':'MATCH (n:User) RETURN n'}]}"));
            MatcherAssert.assertThat((Object)response.get("results").get(0).get("data").size(), (Matcher)CoreMatchers.equalTo((Object)1));
        }
    }
}

