/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.configuration.ConfigurationBuilder;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;

public class MapConfigurator
implements ConfigurationBuilder {
    private final Map<String, String> config;
    private final List<ThirdPartyJaxRsPackage> extensions;

    public MapConfigurator(Map<String, String> config, List<ThirdPartyJaxRsPackage> extensions) {
        this.config = config;
        this.extensions = extensions;
    }

    public Map<String, String> getDatabaseTuningProperties() {
        return this.config;
    }

    public Config configuration() {
        HashMap<String, String> serverConfigParams = new HashMap<String, String>();
        serverConfigParams.putAll(this.config);
        serverConfigParams.put(ServerSettings.third_party_packages.name(), ConfigurationBuilder.ConfiguratorWrappingConfigurationBuilder.toStringForThirdPartyPackageProperty(this.extensions));
        return new Config(serverConfigParams);
    }
}

