/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension.guard;

import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.test.extension.guard.AnnotationClassCollectorVisitor;
import org.neo4j.test.extension.guard.FieldClassCollectorVisitor;
import org.neo4j.test.extension.guard.MethodClassCollectorVisitor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;

public class DependenciesCollector
extends ClassVisitor {
    private static final int API_VERSION = 589824;
    private final AnnotationVisitor annotationVisitor;
    private final MethodVisitor methodVisitor;
    private final FieldVisitor fieldVisitor;
    private final Set<String> descriptors = new HashSet<String>();
    private final Set<String> seenClasses = new HashSet<String>();
    private final Deque<String> classes;

    DependenciesCollector(Deque<String> classes) {
        super(589824);
        this.classes = classes;
        this.annotationVisitor = new AnnotationClassCollectorVisitor(589824, this.descriptors);
        this.methodVisitor = new MethodClassCollectorVisitor(589824, this.descriptors, this.annotationVisitor);
        this.fieldVisitor = new FieldClassCollectorVisitor(589824, this.descriptors, this.annotationVisitor);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (superName != null && this.seenClasses.add(superName)) {
            this.classes.push(superName);
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (this.seenClasses.add(name)) {
            this.classes.push(name);
        }
        super.visitInnerClass(name, outerName, innerName, access);
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        this.descriptors.add(descriptor);
        return this.annotationVisitor;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        this.descriptors.add(descriptor);
        return this.annotationVisitor;
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        this.descriptors.add(descriptor);
        return this.fieldVisitor;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        return this.methodVisitor;
    }

    Set<String> getJunitTestClasses() {
        return this.descriptors.stream().filter(d -> d.startsWith("org/junit") || d.startsWith("Lorg/junit")).map(d -> d.startsWith("o") ? Type.getObjectType((String)d) : Type.getType((String)d)).map(Type::getClassName).collect(Collectors.toSet());
    }
}

