/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.ssl;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Random;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public final class CertificateChainFactory {
    private static final Date NOT_BEFORE = new Date(System.currentTimeMillis() - 31536000000L);
    private static final Date NOT_AFTER = new Date(253402300799000L);
    private static volatile boolean cleanupRequired = true;

    private CertificateChainFactory() {
    }

    public static void createCertificateChain(Path endUserCertPath, Path endUserPrivateKeyPath, Path intCertPath, Path intPrivateKeyPath, Path rootCertPath, Path rootPrivateKeyPath, int ocspServerPortNo, BouncyCastleProvider bouncyCastleProvider) throws Exception {
        Security.addProvider((Provider)bouncyCastleProvider);
        CertificateChainFactory.installCleanupHook(bouncyCastleProvider);
        String ocspBaseURL = "http://localhost:" + ocspServerPortNo;
        KeyPair rootCertKeyPair = CertificateChainFactory.generateKeyPair();
        KeyPair intCertKeyPair = CertificateChainFactory.generateKeyPair();
        KeyPair endUserCertKeyPair = CertificateChainFactory.generateKeyPair();
        X509Certificate rootCert = CertificateChainFactory.generateCertificate(null, null, rootCertKeyPair, "rootCA", ocspBaseURL, rootCertPath, rootPrivateKeyPath, bouncyCastleProvider);
        X509Certificate intCert = CertificateChainFactory.generateCertificate(rootCert, rootCertKeyPair.getPrivate(), intCertKeyPair, "intCA", ocspBaseURL, intCertPath, intPrivateKeyPath, bouncyCastleProvider);
        X509Certificate endUserCert = CertificateChainFactory.generateCertificate(intCert, intCertKeyPair.getPrivate(), endUserCertKeyPair, "endUserCA", ocspBaseURL, endUserCertPath, endUserPrivateKeyPath, bouncyCastleProvider);
        CertificateChainFactory.writePem("CERTIFICATE", endUserCert.getEncoded(), intCert.getEncoded(), rootCert.getEncoded(), endUserCertPath);
        CertificateChainFactory.writePem("PRIVATE KEY", endUserCertKeyPair.getPrivate().getEncoded(), endUserPrivateKeyPath);
        cleanupRequired = false;
    }

    private static KeyPair generateKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA", "BC");
        kpGen.initialize(2048, new SecureRandom());
        return kpGen.generateKeyPair();
    }

    private static X509Certificate generateCertificate(X509Certificate issuingCert, PrivateKey issuingPrivateKey, KeyPair certKeyPair, String certName, String ocspURL, Path certificatePath, Path keyPath, BouncyCastleProvider bouncyCastleProvider) throws Exception {
        JcaX509v3CertificateBuilder builder = issuingCert == null ? new JcaX509v3CertificateBuilder(new X500Name("CN=" + certName), BigInteger.valueOf(new Random().nextInt()), NOT_BEFORE, NOT_AFTER, new X500Name("CN=" + certName), certKeyPair.getPublic()) : new JcaX509v3CertificateBuilder(issuingCert, BigInteger.valueOf(new Random().nextInt()), NOT_BEFORE, NOT_AFTER, new X500Name("CN=" + certName), certKeyPair.getPublic());
        builder.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(132));
        builder.addExtension(Extension.extendedKeyUsage, true, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.anyExtendedKeyUsage));
        builder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(true));
        builder.addExtension(Extension.authorityInfoAccess, false, (ASN1Encodable)new AuthorityInformationAccess(new AccessDescription(AccessDescription.id_ad_ocsp, new GeneralName(6, ocspURL + "/" + certName))));
        X509Certificate certificate = new JcaX509CertificateConverter().getCertificate(builder.build(new JcaContentSignerBuilder("SHA256withRSA").setProvider((Provider)bouncyCastleProvider).build(issuingPrivateKey == null ? certKeyPair.getPrivate() : issuingPrivateKey)));
        CertificateChainFactory.writePem("CERTIFICATE", certificate.getEncoded(), certificatePath);
        CertificateChainFactory.writePem("PRIVATE KEY", certKeyPair.getPrivate().getEncoded(), keyPath);
        return certificate;
    }

    private static void installCleanupHook(BouncyCastleProvider bouncyCastleProvider) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (cleanupRequired) {
                System.err.println("Cleaning up partially generated self-signed certificate...");
                Security.removeProvider(bouncyCastleProvider.getName());
            }
        }));
    }

    private static void writePem(String type, byte[] encodedContent, Path path) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (PemWriter writer = new PemWriter((Writer)Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]));){
            writer.writeObject((PemObjectGenerator)new PemObject(type, encodedContent));
            writer.flush();
        }
        try {
            Files.setPosixFilePermissions(path, Set.of(PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_READ));
        }
        catch (UnsupportedOperationException ignore) {
            File file = path.toFile();
            file.setReadable(false, false);
            file.setWritable(false, false);
            file.setReadable(true);
            file.setWritable(true);
        }
    }

    private static void writePem(String type, byte[] certA, byte[] certB, byte[] certC, Path path) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (PemWriter writer = new PemWriter((Writer)Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]));){
            writer.writeObject((PemObjectGenerator)new PemObject(type, certA));
            writer.writeObject((PemObjectGenerator)new PemObject(type, certB));
            writer.writeObject((PemObjectGenerator)new PemObject(type, certC));
            writer.flush();
        }
        try {
            Files.setPosixFilePermissions(path, Set.of(PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_READ));
        }
        catch (UnsupportedOperationException ignore) {
            File file = path.toFile();
            file.setReadable(false, false);
            file.setWritable(false, false);
            file.setReadable(true);
            file.setWritable(true);
        }
    }
}

