/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.Closeable;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Predicate;
import org.neo4j.test.Race;

public class OtherThreadExecutor
implements ThreadFactory,
Closeable {
    private final ExecutorService commandExecutor = Executors.newSingleThreadExecutor(this);
    private volatile Thread thread;
    private volatile ExecutionState executionState;
    private final String name;
    private final long timeoutNanos;

    public OtherThreadExecutor(String name) {
        this(name, 1L, TimeUnit.MINUTES);
    }

    public OtherThreadExecutor(String name, long timeout, TimeUnit unit) {
        this.name = name;
        this.timeoutNanos = TimeUnit.NANOSECONDS.convert(timeout, unit);
    }

    public <R> Future<R> executeDontWait(Callable<R> cmd) {
        this.executionState = ExecutionState.REQUESTED_EXECUTION;
        return this.commandExecutor.submit(() -> {
            this.executionState = ExecutionState.EXECUTING;
            try {
                Object v = cmd.call();
                return v;
            }
            finally {
                this.executionState = ExecutionState.EXECUTED;
            }
        });
    }

    public <R> R execute(Callable<R> cmd) throws Exception {
        return this.executeDontWait(cmd).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R execute(Callable<R> cmd, long timeout, TimeUnit unit) throws Exception {
        Future<R> future = this.executeDontWait(cmd);
        boolean success = false;
        try {
            this.awaitStartExecuting();
            R result = future.get(timeout, unit);
            success = true;
            R r = result;
            return r;
        }
        finally {
            if (!success) {
                future.cancel(true);
            }
        }
    }

    public void awaitStartExecuting() throws InterruptedException {
        while (this.executionState == ExecutionState.REQUESTED_EXECUTION) {
            Thread.sleep(10L);
        }
    }

    public <R> R awaitFuture(Future<R> future) throws InterruptedException, ExecutionException, TimeoutException {
        return future.get(this.timeoutNanos, TimeUnit.NANOSECONDS);
    }

    public static <R> Callable<R> command(Race.ThrowingRunnable runnable) {
        return () -> {
            try {
                runnable.run();
                return null;
            }
            catch (Exception e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        };
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread newThread;
        this.thread = newThread = new Thread(r, this.getClass().getName() + ":" + this.name){

            @Override
            public void run() {
                try {
                    super.run();
                }
                finally {
                    OtherThreadExecutor.this.thread = null;
                }
            }
        };
        return newThread;
    }

    public String toString() {
        Thread thread = this.thread;
        return String.format("%s[%s,state=%s]", this.getClass().getSimpleName(), this.name, thread == null ? "dead" : thread.getState());
    }

    public WaitDetails waitUntilWaiting() throws TimeoutException {
        return this.waitUntilWaiting(details -> true);
    }

    public WaitDetails waitUntilBlocked() throws TimeoutException {
        return this.waitUntilBlocked(details -> true);
    }

    public WaitDetails waitUntilWaiting(Predicate<WaitDetails> correctWait) throws TimeoutException {
        return this.waitUntilThreadState(correctWait, Thread.State.WAITING, Thread.State.TIMED_WAITING);
    }

    public WaitDetails waitUntilBlocked(Predicate<WaitDetails> correctWait) throws TimeoutException {
        return this.waitUntilThreadState(correctWait, Thread.State.BLOCKED);
    }

    public WaitDetails waitUntilThreadState(Thread.State ... possibleStates) throws TimeoutException {
        return this.waitUntilThreadState((WaitDetails details) -> true, possibleStates);
    }

    public WaitDetails waitUntilThreadState(Predicate<WaitDetails> correctWait, Thread.State ... possibleStates) throws TimeoutException {
        WaitDetails details;
        long endTimeNanos = System.nanoTime() + this.timeoutNanos;
        while (!correctWait.test(details = this.waitUntil(new AnyThreadState(possibleStates)))) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(20L));
            if (System.nanoTime() <= endTimeNanos) continue;
            throw new TimeoutException("Wanted to wait for any of " + Arrays.toString((Object[])possibleStates) + " over at " + correctWait + ", but didn't managed to get there in " + this.timeoutNanos + "ns. instead ended up waiting in " + details);
        }
        return details;
    }

    public WaitDetails waitUntil(Predicate<Thread> condition) throws TimeoutException {
        long end = System.nanoTime() + this.timeoutNanos;
        Thread thread = this.getThread();
        while (!condition.test(thread) || this.executionState == ExecutionState.REQUESTED_EXECUTION) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.nanoTime() <= end) continue;
            throw new TimeoutException("The executor didn't meet condition '" + condition + "' inside an executing command for " + this.timeoutNanos + " ns");
        }
        if (this.executionState == ExecutionState.EXECUTED) {
            throw new IllegalStateException("Would have wanted " + thread + " to wait for " + condition + " but that never happened within the duration of executed task");
        }
        return new WaitDetails(thread.getStackTrace());
    }

    public Thread.State state() {
        return this.thread.getState();
    }

    private Thread getThread() {
        Thread thread = null;
        while (thread == null) {
            thread = this.thread;
        }
        return thread;
    }

    @Override
    public void close() {
        this.commandExecutor.shutdown();
        try {
            this.commandExecutor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (!this.commandExecutor.isTerminated()) {
            this.commandExecutor.shutdownNow();
        }
    }

    public void interrupt() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public void printStackTrace(PrintStream out) {
        Thread thread = this.getThread();
        out.println(thread);
        for (StackTraceElement trace : thread.getStackTrace()) {
            out.println("\tat " + trace);
        }
    }

    private static enum ExecutionState {
        REQUESTED_EXECUTION,
        EXECUTING,
        EXECUTED;

    }

    public static class WaitDetails {
        private final StackTraceElement[] stackTrace;

        public WaitDetails(StackTraceElement[] stackTrace) {
            this.stackTrace = stackTrace;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (StackTraceElement element : this.stackTrace) {
                builder.append(String.format(element + "%n", new Object[0]));
            }
            return builder.toString();
        }

        public boolean isAt(Class<?> clz, String method) {
            for (StackTraceElement element : this.stackTrace) {
                if (!element.getClassName().equals(clz.getName()) || !element.getMethodName().equals(method)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class AnyThreadState
    implements Predicate<Thread> {
        private final EnumSet<Thread.State> possibleStates;
        private final EnumSet<Thread.State> seenStates = EnumSet.noneOf(Thread.State.class);

        private AnyThreadState(Thread.State ... possibleStates) {
            this.possibleStates = EnumSet.noneOf(Thread.State.class);
            this.possibleStates.addAll(Arrays.asList(possibleStates));
        }

        @Override
        public boolean test(Thread thread) {
            Thread.State threadState = thread.getState();
            this.seenStates.add(threadState);
            return this.possibleStates.contains((Object)threadState);
        }

        public String toString() {
            return "Any of thread states " + this.possibleStates + ", but saw " + this.seenStates;
        }
    }

    public static interface WorkerCommand<R> {
        public R doWork() throws Exception;
    }
}

