/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule.concurrent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.rules.ExternalResource;
import org.neo4j.function.FailableConsumer;
import org.neo4j.function.Predicates;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.function.ThrowingPredicate;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.test.ReflectionUtil;

public class ThreadingRule
extends ExternalResource {
    private ExecutorService executor;
    private static final FailableConsumer<Thread> NULL_CONSUMER = new FailableConsumer<Thread>(){

        public void fail(Exception failure) {
        }

        public void accept(Thread thread) {
        }
    };

    protected void before() {
        this.executor = Executors.newCachedThreadPool();
    }

    protected void after() {
        try {
            this.executor.shutdownNow();
            this.executor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.executor = null;
        }
    }

    public <FROM, TO, EX extends Exception> Future<TO> execute(ThrowingFunction<FROM, TO, EX> function, FROM parameter) {
        return this.executor.submit(ThreadingRule.task(function, function.toString(), parameter, NULL_CONSUMER));
    }

    public <FROM, TO, EX extends Exception> List<Future<TO>> multiple(int threads, ThrowingFunction<FROM, TO, EX> function, FROM parameter) {
        ArrayList<Future<TO>> result = new ArrayList<Future<TO>>(threads);
        for (int i = 0; i < threads; ++i) {
            result.add(this.executor.submit(ThreadingRule.task(function, function + ":task=" + i, parameter, NULL_CONSUMER)));
        }
        return result;
    }

    public <FROM, TO, EX extends Exception> Future<TO> executeAndAwait(ThrowingFunction<FROM, TO, EX> function, FROM parameter, Predicate<Thread> threadCondition, long timeout, TimeUnit unit) throws ExecutionException {
        FailableConcurrentTransfer<Thread> transfer = new FailableConcurrentTransfer<Thread>();
        Future<TO> future = this.executor.submit(ThreadingRule.task(function, function.toString(), parameter, transfer));
        try {
            Predicates.awaitEx(transfer, (ThrowingPredicate)ThrowingPredicate.throwingPredicate(threadCondition), (long)timeout, (TimeUnit)unit);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
        return future;
    }

    private static <FROM, TO, EX extends Exception> Callable<TO> task(ThrowingFunction<FROM, TO, EX> function, String name, FROM parameter, FailableConsumer<Thread> threadConsumer) {
        return () -> {
            Thread thread = Thread.currentThread();
            String previousName = thread.getName();
            thread.setName(name);
            threadConsumer.accept((Object)thread);
            try {
                Object object = function.apply(parameter);
                return object;
            }
            catch (Exception failure) {
                threadConsumer.fail(failure);
                throw failure;
            }
            finally {
                thread.setName(previousName);
            }
        };
    }

    public static Predicate<Thread> waitingWhileIn(final Class<?> owner, final String ... eitherOfMethods) {
        for (String method : eitherOfMethods) {
            ReflectionUtil.verifyMethodExists(owner, method);
        }
        return new Predicate<Thread>(){

            @Override
            public boolean test(Thread thread) {
                if (thread == null) {
                    return false;
                }
                if (thread.getState() == Thread.State.WAITING || thread.getState() == Thread.State.TIMED_WAITING) {
                    for (StackTraceElement element : thread.getStackTrace()) {
                        try {
                            Class<?> currentClass = Class.forName(element.getClassName());
                            boolean currentClassIsSubtype = owner.isAssignableFrom(currentClass);
                            if (currentClassIsSubtype && ArrayUtils.contains((Object[])eitherOfMethods, (Object)element.getMethodName())) {
                                return true;
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                }
                return false;
            }

            public String toString() {
                return String.format("Predicate[Thread.state=WAITING && call stack contains %s.%s()]", owner.getName(), Arrays.toString(eitherOfMethods));
            }
        };
    }

    private static class FailableConcurrentTransfer<TYPE>
    implements FailableConsumer<TYPE>,
    ThrowingSupplier<TYPE, Exception> {
        private final CountDownLatch latch = new CountDownLatch(1);
        private TYPE value;
        private Exception failure;

        private FailableConcurrentTransfer() {
        }

        public void accept(TYPE value) {
            this.value = value;
            this.latch.countDown();
        }

        public void fail(Exception failure) {
            this.failure = failure;
            this.latch.countDown();
        }

        public TYPE get() throws Exception {
            this.latch.await();
            if (this.failure != null) {
                throw this.failure;
            }
            return this.value;
        }

        public String toString() {
            return String.format("ConcurrentTransfer{%s}", this.latch.getCount() == 1L ? "<waiting>" : this.value);
        }
    }
}

