/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension.timeout;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.awaitility.core.ConditionTimeoutException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;
import org.neo4j.internal.utils.DumpUtils;

public class VerboseTimeoutExceptionExtension
implements TestWatcher {
    public void testFailed(ExtensionContext context, Throwable cause) {
        if (VerboseTimeoutExceptionExtension.isTimeout(cause)) {
            cause.addSuppressed(new ThreadDump(String.format("Test %s-%s timed out. ", context.getRequiredTestMethod().getName(), context.getDisplayName())));
        }
    }

    private static boolean isTimeout(Throwable throwable) {
        return throwable != null && (throwable instanceof TimeoutException || throwable instanceof ConditionTimeoutException || StringUtils.contains((CharSequence)throwable.getMessage(), (CharSequence)"timed out") || !Objects.equals(throwable, throwable.getCause()) && VerboseTimeoutExceptionExtension.isTimeout(throwable.getCause()) || Arrays.stream(throwable.getSuppressed()).anyMatch(VerboseTimeoutExceptionExtension::isTimeout));
    }

    static class ThreadDump
    extends RuntimeException {
        ThreadDump(String header) {
            super(header + DumpUtils.threadDump());
            this.setStackTrace(new StackTraceElement[0]);
        }
    }
}

