/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.mockito.mock;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public class Link {
    final Relationship relationship;
    private final Node node;
    private final boolean isStartNode;

    public static Link link(Relationship relationship, Node node) {
        if (relationship.getStartNode().getId() == node.getId()) {
            return new Link(node, relationship);
        }
        if (relationship.getEndNode().getId() == node.getId()) {
            return new Link(relationship, node);
        }
        throw Link.illegalArgument("%s is neither the start node nor the end node of %s", node, relationship);
    }

    private Link(Node node, Relationship relationship) {
        this.relationship = relationship;
        this.node = node;
        this.isStartNode = true;
    }

    private Link(Relationship relationship, Node node) {
        this.relationship = relationship;
        this.node = node;
        this.isStartNode = false;
    }

    public Node checkNode(Node node) {
        if (this.isStartNode) {
            if (node.getId() != this.relationship.getEndNode().getId()) {
                throw Link.illegalArgument("%s is not the end node of %s", node, this.relationship);
            }
        } else if (node.getId() != this.relationship.getStartNode().getId()) {
            throw Link.illegalArgument("%s is not the start node of %s", node, this.relationship);
        }
        return this.node;
    }

    private static IllegalArgumentException illegalArgument(String message, Object ... parameters) {
        return new IllegalArgumentException(String.format(message, parameters));
    }
}

