/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class Unzip {
    private Unzip() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path unzip(Class<?> testClass, String resource, Path targetDirectory) throws IOException {
        InputStream source = testClass.getResourceAsStream(resource);
        if (source == null) {
            throw new NoSuchFileException("Could not find resource '" + resource + "' to unzip");
        }
        try (ZipInputStream zipStream = new ZipInputStream(source);){
            ZipEntry entry;
            byte[] scratch = new byte[8096];
            while ((entry = zipStream.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    Files.createDirectories(targetDirectory.resolve(entry.getName()), new FileAttribute[0]);
                } else {
                    try (BufferedOutputStream file = new BufferedOutputStream(Files.newOutputStream(targetDirectory.resolve(entry.getName()), new OpenOption[0]));){
                        int read;
                        while ((read = zipStream.read(scratch)) != -1) {
                            ((OutputStream)file).write(scratch, 0, read);
                        }
                    }
                }
                zipStream.closeEntry();
            }
        }
        finally {
            source.close();
        }
        return targetDirectory;
    }
}

