/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension.timeout;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.PreInterruptCallback;
import org.junit.jupiter.api.extension.PreInterruptContext;
import org.neo4j.internal.helpers.NamedThreadFactory;

public class TimeoutGuardExtension
implements PreInterruptCallback {
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("HangingTestMonitor"));

    public void beforeThreadInterrupt(PreInterruptContext preInterruptContext, ExtensionContext extensionContext) {
        executor.schedule(new HangingTestWatchTask(preInterruptContext.getThreadToInterrupt(), extensionContext.getRequiredTestMethod()), 1L, TimeUnit.MINUTES);
    }

    private static class HangingTestWatchTask
    implements Runnable {
        private final Thread testThread;
        private final Method requiredTestMethod;

        public HangingTestWatchTask(Thread testThread, Method requiredTestMethod) {
            this.testThread = testThread;
            this.requiredTestMethod = requiredTestMethod;
        }

        @Override
        public void run() {
            String clazz = this.requiredTestMethod.getDeclaringClass().getName();
            String methodName = this.requiredTestMethod.getName();
            for (StackTraceElement stackTraceElement : this.testThread.getStackTrace()) {
                if (!clazz.equals(stackTraceElement.getClassName()) || !methodName.equals(stackTraceElement.getMethodName())) continue;
                String message = "                          ***WARNING***\nTest monitor terminating hanging execution for test %s.%s\nAfter the test timeout was reached, an interruption attempt was made; however, the test did not progress within the allocated grace period. Terminating the VM.".formatted(clazz, methodName);
                HangingTestWatchTask.printWarning(System.out, message);
                HangingTestWatchTask.printWarning(System.err, message);
                System.exit(1);
            }
        }

        private static void printWarning(PrintStream out, String message) {
            out.println(message);
            out.flush();
        }
    }
}

