/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension.guard;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.JUnitException;
import org.neo4j.test.extension.guard.DependenciesCollector;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class JUnitUsageGuardExtension
implements BeforeAllCallback {
    public void beforeAll(ExtensionContext context) throws Exception {
        Class testClazz = context.getRequiredTestClass();
        Set<String> testClasses = JUnitUsageGuardExtension.collectUsedTestClasses(testClazz);
        testClasses.removeIf(s -> s.startsWith("org.junit.platform"));
        testClasses.removeIf(s -> s.startsWith("org.junit.runners.model"));
        testClasses.removeIf(s -> s.equals("org.junit.runner.Description"));
        Set<String> newJunitClasses = testClasses.stream().filter(s -> s.startsWith("org.junit.jupiter")).collect(Collectors.toSet());
        if (newJunitClasses.isEmpty() || JUnitUsageGuardExtension.noOldJunitUsages(testClasses, newJunitClasses)) {
            return;
        }
        testClasses.removeAll(newJunitClasses);
        throw new JUnitException(String.format("Detect usage of classes from multiple junit versions in the single test class: %s.%nDetected JUnit 5 classes: %s.%nDetected Junit 4 classes: %s.", testClazz.getName(), JUnitUsageGuardExtension.sortedClasses(newJunitClasses), JUnitUsageGuardExtension.sortedClasses(testClasses)));
    }

    private static List<String> sortedClasses(Set<String> newJunitClasses) {
        ArrayList<String> strings = new ArrayList<String>(newJunitClasses);
        Collections.sort(strings);
        return strings;
    }

    private static boolean noOldJunitUsages(Set<String> testClasses, Set<String> newJunitClasses) {
        return newJunitClasses.size() == testClasses.size();
    }

    private static Set<String> collectUsedTestClasses(Class<?> clazz) {
        ArrayDeque<String> classes = new ArrayDeque<String>();
        classes.push(clazz.getName());
        DependenciesCollector dependenciesCollector = new DependenciesCollector(classes);
        while (!classes.isEmpty()) {
            try {
                ClassReader classReader = new ClassReader((String)classes.pop());
                classReader.accept((ClassVisitor)dependenciesCollector, 6);
            }
            catch (IOException iOException) {}
        }
        return dependenciesCollector.getJunitTestClasses();
    }
}

