/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.springframework.boot.autoconfigure.data;

import org.neo4j.driver.Driver;
import org.neo4j.driver.springframework.boot.autoconfigure.Neo4jDriverAutoConfiguration;
import org.neo4j.springframework.boot.autoconfigure.data.Neo4jDataProperties;
import org.neo4j.springframework.boot.autoconfigure.data.Neo4jReactiveRepositoriesConfiguration;
import org.neo4j.springframework.data.config.Neo4jDefaultReactiveCallbacksRegistrar;
import org.neo4j.springframework.data.core.ReactiveDatabaseSelectionProvider;
import org.neo4j.springframework.data.core.ReactiveNeo4jClient;
import org.neo4j.springframework.data.core.ReactiveNeo4jOperations;
import org.neo4j.springframework.data.core.ReactiveNeo4jTemplate;
import org.neo4j.springframework.data.core.mapping.Neo4jMappingContext;
import org.neo4j.springframework.data.core.transaction.ReactiveNeo4jTransactionManager;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.ConditionalOnRepositoryType;
import org.springframework.boot.autoconfigure.data.RepositoryType;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.transaction.ReactiveTransactionManager;
import reactor.core.publisher.Flux;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ReactiveNeo4jTransactionManager.class, ReactiveTransactionManager.class, Flux.class})
@ConditionalOnRepositoryType(store="neo4j", type=RepositoryType.REACTIVE)
@AutoConfigureAfter(value={Neo4jDriverAutoConfiguration.class})
@AutoConfigureBefore(value={Neo4jReactiveRepositoriesConfiguration.class})
@Import(value={Neo4jDefaultReactiveCallbacksRegistrar.class})
class Neo4jReactiveDataConfiguration {
    Neo4jReactiveDataConfiguration() {
    }

    @Bean(value={"reactiveDatabaseSelectionProvider"})
    @ConditionalOnProperty(prefix="org.neo4j.data", name={"database"})
    @ConditionalOnMissingBean
    @Order(value=-30)
    public ReactiveDatabaseSelectionProvider staticDatabaseSelectionProvider(Neo4jDataProperties dataProperties) {
        return ReactiveDatabaseSelectionProvider.createStaticDatabaseSelectionProvider((String)dataProperties.getDatabase());
    }

    @Bean(value={"reactiveDatabaseSelectionProvider"})
    @ConditionalOnMissingBean
    @Order(value=-20)
    public ReactiveDatabaseSelectionProvider defaultSelectionProvider() {
        return ReactiveDatabaseSelectionProvider.getDefaultSelectionProvider();
    }

    @Bean(value={"reactiveNeo4jClient"})
    @ConditionalOnMissingBean
    public ReactiveNeo4jClient neo4jClient(Driver driver) {
        return ReactiveNeo4jClient.create((Driver)driver);
    }

    @Bean(value={"reactiveNeo4jTemplate"})
    @ConditionalOnMissingBean(value={ReactiveNeo4jOperations.class})
    public ReactiveNeo4jTemplate neo4jTemplate(ReactiveNeo4jClient neo4jClient, Neo4jMappingContext neo4jMappingContext, ReactiveDatabaseSelectionProvider databaseNameProvider) {
        return new ReactiveNeo4jTemplate(neo4jClient, neo4jMappingContext, databaseNameProvider);
    }

    @Bean(value={"reactiveTransactionManager"})
    @ConditionalOnMissingBean(value={ReactiveTransactionManager.class})
    public ReactiveTransactionManager transactionManager(Driver driver, ReactiveDatabaseSelectionProvider databaseNameProvider) {
        return new ReactiveNeo4jTransactionManager(driver, databaseNameProvider);
    }
}

