/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.springframework.boot.autoconfigure.data;

import org.neo4j.driver.Driver;
import org.neo4j.driver.springframework.boot.autoconfigure.Neo4jDriverAutoConfiguration;
import org.neo4j.springframework.boot.autoconfigure.data.Neo4jDataProperties;
import org.neo4j.springframework.boot.autoconfigure.data.Neo4jImperativeRepositoriesConfiguration;
import org.neo4j.springframework.data.config.Neo4jDefaultCallbacksRegistrar;
import org.neo4j.springframework.data.core.DatabaseSelectionProvider;
import org.neo4j.springframework.data.core.Neo4jClient;
import org.neo4j.springframework.data.core.Neo4jOperations;
import org.neo4j.springframework.data.core.Neo4jTemplate;
import org.neo4j.springframework.data.core.mapping.Neo4jMappingContext;
import org.neo4j.springframework.data.core.transaction.Neo4jTransactionManager;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.ConditionalOnRepositoryType;
import org.springframework.boot.autoconfigure.data.RepositoryType;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Neo4jTransactionManager.class, PlatformTransactionManager.class})
@ConditionalOnRepositoryType(store="neo4j", type=RepositoryType.IMPERATIVE)
@AutoConfigureAfter(value={Neo4jDriverAutoConfiguration.class})
@AutoConfigureBefore(value={Neo4jImperativeRepositoriesConfiguration.class})
@Import(value={Neo4jDefaultCallbacksRegistrar.class})
class Neo4jImperativeDataConfiguration {
    Neo4jImperativeDataConfiguration() {
    }

    @Bean(value={"databaseSelectionProvider"})
    @ConditionalOnProperty(prefix="org.neo4j.data", name={"database"})
    @ConditionalOnMissingBean
    @Order(value=-30)
    public DatabaseSelectionProvider staticDatabaseSelectionProvider(Neo4jDataProperties dataProperties) {
        return DatabaseSelectionProvider.createStaticDatabaseSelectionProvider((String)dataProperties.getDatabase());
    }

    @Bean(value={"databaseSelectionProvider"})
    @ConditionalOnMissingBean
    @Order(value=-20)
    public DatabaseSelectionProvider defaultSelectionProvider() {
        return DatabaseSelectionProvider.getDefaultSelectionProvider();
    }

    @Bean(value={"neo4jClient"})
    @ConditionalOnMissingBean
    public Neo4jClient neo4jClient(Driver driver) {
        return Neo4jClient.create((Driver)driver);
    }

    @Bean(value={"neo4jTemplate"})
    @ConditionalOnMissingBean(value={Neo4jOperations.class})
    public Neo4jTemplate neo4jTemplate(Neo4jClient neo4jClient, Neo4jMappingContext neo4jMappingContext, DatabaseSelectionProvider databaseNameProvider) {
        return new Neo4jTemplate(neo4jClient, neo4jMappingContext, databaseNameProvider);
    }

    @Bean(value={"transactionManager"})
    @ConditionalOnMissingBean(value={PlatformTransactionManager.class})
    public Neo4jTransactionManager transactionManager(Driver driver, DatabaseSelectionProvider databaseNameProvider, ObjectProvider<TransactionManagerCustomizers> optionalCustomizers) {
        Neo4jTransactionManager transactionManager = new Neo4jTransactionManager(driver, databaseNameProvider);
        optionalCustomizers.ifAvailable(customizer -> customizer.customize((PlatformTransactionManager)transactionManager));
        return transactionManager;
    }
}

