/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.springframework.boot.autoconfigure.data;

import java.util.Set;
import org.neo4j.driver.Driver;
import org.neo4j.springframework.boot.autoconfigure.data.Neo4jDataProperties;
import org.neo4j.springframework.boot.autoconfigure.data.Neo4jImperativeDataConfiguration;
import org.neo4j.springframework.boot.autoconfigure.data.Neo4jReactiveDataConfiguration;
import org.neo4j.springframework.data.core.convert.Neo4jConversions;
import org.neo4j.springframework.data.core.mapping.Neo4jMappingContext;
import org.neo4j.springframework.data.core.schema.Node;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.domain.EntityScanner;
import org.springframework.boot.autoconfigure.transaction.TransactionAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={Driver.class})
@EnableConfigurationProperties(value={Neo4jDataProperties.class})
@AutoConfigureBefore(value={TransactionAutoConfiguration.class})
@Import(value={Neo4jImperativeDataConfiguration.class, Neo4jReactiveDataConfiguration.class})
public final class Neo4jDataAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public Neo4jConversions neo4jConversions() {
        return new Neo4jConversions();
    }

    @Bean
    @ConditionalOnMissingBean
    public Neo4jMappingContext neo4jMappingContext(ApplicationContext applicationContext, Neo4jConversions neo4jConversions) throws ClassNotFoundException {
        Set initialEntityClasses = new EntityScanner(applicationContext).scan(new Class[]{Node.class});
        Neo4jMappingContext context = new Neo4jMappingContext(neo4jConversions);
        context.setInitialEntitySet(initialEntityClasses);
        return context;
    }
}

