/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import org.neo4j.server.rest.repr.ListWriter;
import org.neo4j.server.rest.repr.RepresentationType;

public abstract class MappingWriter {
    public MappingWriter newMapping(RepresentationType type, String param) {
        return this.newMapping(type.valueName, param);
    }

    protected abstract MappingWriter newMapping(String var1, String var2);

    ListWriter newList(RepresentationType type, String param) {
        if (type.valueName.equals("map")) {
            return this.newList(type.listName, param);
        }
        if (type.listName == null) {
            throw new IllegalStateException("Invalid list type: " + type);
        }
        return this.newList(type.listName, param);
    }

    protected abstract ListWriter newList(String var1, String var2);

    protected void writeString(String key, String value) {
        this.writeValue(RepresentationType.STRING, key, (Object)value);
    }

    void writeInteger(RepresentationType type, String param, long property) {
        this.writeInteger(type.valueName, param, property);
    }

    protected void writeInteger(String type, String key, long value) {
        this.writeValue(type, key, (Object)value);
    }

    void writeFloatingPointNumber(RepresentationType type, String key, double value) {
        this.writeFloatingPointNumber(type.valueName, key, value);
    }

    protected void writeFloatingPointNumber(String type, String key, double value) {
        this.writeValue(type, key, (Object)value);
    }

    protected void writeBoolean(String key, boolean value) {
        this.writeValue(RepresentationType.BOOLEAN, key, (Object)value);
    }

    void writeValue(RepresentationType type, String key, Object value) {
        this.writeValue(type.valueName, key, value);
    }

    protected abstract void writeValue(String var1, String var2, Object var3);

    public abstract void done();
}

