/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.plugins;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.NestingIterable;
import org.neo4j.server.plugins.PluginLookupException;
import org.neo4j.server.plugins.PluginPoint;
import org.neo4j.server.plugins.PluginPointFactory;

public final class ServerExtender {
    private final Map<Class<?>, Map<String, PluginPoint>> targetToPluginMap = new HashMap();
    private PluginPointFactory pluginPointFactory;

    ServerExtender(PluginPointFactory pluginPointFactory) {
        this.pluginPointFactory = pluginPointFactory;
        this.targetToPluginMap.put(Node.class, new ConcurrentHashMap());
        this.targetToPluginMap.put(Relationship.class, new ConcurrentHashMap());
        this.targetToPluginMap.put(GraphDatabaseService.class, new ConcurrentHashMap());
    }

    Iterable<PluginPoint> getExtensionsFor(Class<?> type) {
        Map<String, PluginPoint> ext = this.targetToPluginMap.get(type);
        if (ext == null) {
            return Collections.emptyList();
        }
        return ext.values();
    }

    Iterable<PluginPoint> all() {
        return new NestingIterable<PluginPoint, Map<String, PluginPoint>>(this.targetToPluginMap.values()){

            protected Iterator<PluginPoint> createNestedIterator(Map<String, PluginPoint> item) {
                return item.values().iterator();
            }
        };
    }

    PluginPoint getExtensionPoint(Class<?> type, String method) throws PluginLookupException {
        Map<String, PluginPoint> ext = this.targetToPluginMap.get(type);
        PluginPoint plugin = null;
        if (ext != null) {
            plugin = ext.get(method);
        }
        if (plugin == null) {
            throw new PluginLookupException("No plugin \"" + method + "\" for " + type);
        }
        return plugin;
    }

    void addExtension(Class<?> type, PluginPoint plugin) {
        Map<String, PluginPoint> ext = this.targetToPluginMap.get(type);
        if (ext == null) {
            throw new IllegalStateException("Cannot extend " + type);
        }
        ServerExtender.add(ext, plugin);
    }

    public void addGraphDatabaseExtensions(PluginPoint plugin) {
        ServerExtender.add(this.targetToPluginMap.get(GraphDatabaseService.class), plugin);
    }

    public void addNodeExtensions(PluginPoint plugin) {
        ServerExtender.add(this.targetToPluginMap.get(Node.class), plugin);
    }

    public void addRelationshipExtensions(PluginPoint plugin) {
        ServerExtender.add(this.targetToPluginMap.get(Relationship.class), plugin);
    }

    private static void add(Map<String, PluginPoint> extensions, PluginPoint plugin) {
        if (extensions.get(plugin.name()) != null) {
            throw new IllegalArgumentException("This plugin already has an plugin point with the name \"" + plugin.name() + "\"");
        }
        extensions.put(plugin.name(), plugin);
    }

    public PluginPointFactory getPluginPointFactory() {
        return this.pluginPointFactory;
    }
}

