/*
 * Decompiled with CFR 0.152.
 */
package apoc.util.s3;

import apoc.util.s3.S3Params;
import apoc.util.s3.S3ParamsExtractor;
import org.junit.Assert;
import org.junit.Test;

public class S3ParamsExtractorTest {
    @Test
    public void testEncodedS3Url() {
        S3Params params = S3ParamsExtractor.extract((String)"s3://accessKeyId:some%2Fsecret%2Fkey:some%2Fsession%2Ftoken@s3.us-east-2.amazonaws.com:1234/bucket/path/to/key");
        Assert.assertEquals((Object)"some/secret/key", (Object)params.getSecretKey());
        Assert.assertEquals((Object)"some/session/token", (Object)params.getSessionToken());
        Assert.assertEquals((Object)"accessKeyId", (Object)params.getAccessKey());
        Assert.assertEquals((Object)"bucket", (Object)params.getBucket());
        Assert.assertEquals((Object)"path/to/key", (Object)params.getKey());
        Assert.assertEquals((Object)"s3.us-east-2.amazonaws.com:1234", (Object)params.getEndpoint());
        Assert.assertEquals((Object)"us-east-2", (Object)params.getRegion());
    }

    @Test
    public void testEncodedS3UrlQueryParams() {
        S3Params params = S3ParamsExtractor.extract((String)"s3://s3.us-east-2.amazonaws.com:1234/bucket/path/to/key?accessKey=accessKeyId&secretKey=some%2Fsecret%2Fkey&sessionToken=some%2Fsession%2Ftoken");
        Assert.assertEquals((Object)"some/secret/key", (Object)params.getSecretKey());
        Assert.assertEquals((Object)"some/session/token", (Object)params.getSessionToken());
        Assert.assertEquals((Object)"accessKeyId", (Object)params.getAccessKey());
        Assert.assertEquals((Object)"bucket", (Object)params.getBucket());
        Assert.assertEquals((Object)"path/to/key", (Object)params.getKey());
        Assert.assertEquals((Object)"s3.us-east-2.amazonaws.com:1234", (Object)params.getEndpoint());
    }

    @Test
    public void testExtractEndpointPort() {
        Assert.assertEquals((Object)"s3.amazonaws.com", (Object)S3ParamsExtractor.extract((String)"s3://s3.amazonaws.com:80/bucket/path/to/key").getEndpoint());
        Assert.assertEquals((Object)"s3.amazonaws.com:1234", (Object)S3ParamsExtractor.extract((String)"s3://s3.amazonaws.com:1234/bucket/path/to/key").getEndpoint());
    }

    @Test
    public void testExtractRegion() {
        Assert.assertEquals((Object)"us-east-2", (Object)S3ParamsExtractor.extract((String)"s3://s3.us-east-2.amazonaws.com:80/bucket/path/to/key").getRegion());
        Assert.assertNull((Object)S3ParamsExtractor.extract((String)"s3://s3.amazonaws.com:80/bucket/path/to/key").getRegion());
    }
}

