/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import apoc.util.Neo4jContainerExtension;
import apoc.util.TestUtil;
import apoc.util.TestcontainersCausalCluster;
import com.github.dockerjava.api.exception.NotFoundException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.junit.Assert;
import org.neo4j.driver.Record;
import org.neo4j.driver.Session;
import org.testcontainers.containers.ContainerFetchException;
import org.testcontainers.utility.MountableFile;

public class TestContainerUtil {
    public static final String neo4jEnterpriseDockerImageVersion = System.getProperty("neo4jDockerImage");
    public static final String neo4jCommunityDockerImageVersion = System.getProperty("neo4jCommunityDockerImage");
    public static final String password = "apoc12345";
    public static File baseDir = Paths.get("..", new String[0]).toFile();
    public static File pluginsFolder = new File(baseDir, "build/plugins");
    public static File importFolder = new File(baseDir, "build/import");
    private static File coreDir = new File(baseDir, System.getProperty("coreDir"));
    public static File extendedDir = new File(baseDir, "extended");

    private TestContainerUtil() {
    }

    public static String dockerImageForNeo4j(Neo4jVersion version) {
        if (version == Neo4jVersion.COMMUNITY) {
            return neo4jCommunityDockerImageVersion;
        }
        return neo4jEnterpriseDockerImageVersion;
    }

    public static TestcontainersCausalCluster createEnterpriseCluster(List<ApocPackage> apocPackages, int numOfCoreInstances, int numberOfReadReplica, Map<String, Object> neo4jConfig, Map<String, String> envSettings) {
        return TestcontainersCausalCluster.create(apocPackages, numOfCoreInstances, numberOfReadReplica, Duration.ofMinutes(4L), neo4jConfig, envSettings);
    }

    public static Neo4jContainerExtension createDB(Neo4jVersion version, List<ApocPackage> apocPackages, boolean withLogging) {
        return switch (version) {
            default -> throw new IncompatibleClassChangeError();
            case Neo4jVersion.ENTERPRISE -> TestContainerUtil.createEnterpriseDB(apocPackages, withLogging);
            case Neo4jVersion.COMMUNITY -> TestContainerUtil.createCommunityDB(apocPackages, withLogging);
        };
    }

    public static Neo4jContainerExtension createEnterpriseDB(List<ApocPackage> apocPackages, boolean withLogging) {
        return TestContainerUtil.createNeo4jContainer(apocPackages, withLogging, Neo4jVersion.ENTERPRISE);
    }

    public static Neo4jContainerExtension createCommunityDB(List<ApocPackage> apocPackages, boolean withLogging) {
        return TestContainerUtil.createNeo4jContainer(apocPackages, withLogging, Neo4jVersion.COMMUNITY);
    }

    private static Neo4jContainerExtension createNeo4jContainer(List<ApocPackage> apocPackages, boolean withLogging, Neo4jVersion version) {
        String dockerImage = version == Neo4jVersion.ENTERPRISE ? neo4jEnterpriseDockerImageVersion : neo4jCommunityDockerImageVersion;
        try {
            FileUtils.deleteDirectory((File)pluginsFolder);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        importFolder.mkdirs();
        pluginsFolder.mkdirs();
        String canonicalPath = null;
        try {
            canonicalPath = importFolder.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (ApocPackage apocPackage : apocPackages) {
            File projectDir = apocPackage == ApocPackage.CORE ? coreDir : extendedDir;
            TestContainerUtil.executeGradleTasks(projectDir, "shadowJar");
            TestContainerUtil.copyFilesToPlugin(new File(projectDir, "build/libs"), (IOFileFilter)new WildcardFileFilter(Arrays.asList("*-extended.jar", "*-core.jar")), pluginsFolder);
        }
        System.out.println("neo4jDockerImageVersion = " + dockerImage);
        Neo4jContainerExtension neo4jContainer = (Neo4jContainerExtension)((Neo4jContainerExtension)((Neo4jContainerExtension)((Neo4jContainerExtension)((Neo4jContainerExtension)((Neo4jContainerExtension)((Neo4jContainerExtension)((Neo4jContainerExtension)((Neo4jContainerExtension)((Neo4jContainerExtension)((Neo4jContainerExtension)((Neo4jContainerExtension)((Neo4jContainerExtension)((Neo4jContainerExtension)((Neo4jContainerExtension)((Neo4jContainerExtension)((Neo4jContainerExtension)((Neo4jContainerExtension)new Neo4jContainerExtension(dockerImage).withPlugins(MountableFile.forHostPath((Path)pluginsFolder.toPath()))).withTmpFs(Map.of("/logs", "rw", "/data", "rw", pluginsFolder.toPath().toAbsolutePath().toString(), "rw"))).withAdminPassword(password)).withEnv("NEO4J_ACCEPT_LICENSE_AGREEMENT", "yes")).withEnv("apoc.export.file.enabled", "true")).withEnv("apoc.import.file.enabled", "true")).withNeo4jConfig("dbms.memory.heap.max_size", "512M")).withNeo4jConfig("dbms.memory.pagecache.size", "256M")).withNeo4jConfig("dbms.security.procedures.unrestricted", "apoc.*")).withNeo4jConfig("dbms.logs.http.enabled", "true")).withNeo4jConfig("dbms.logs.debug.level", "DEBUG")).withNeo4jConfig("dbms.routing.driver.logging.level", "DEBUG")).withNeo4jConfig("internal.dbms.type_constraints", "true")).withFileSystemBind(canonicalPath, "/var/lib/neo4j/import")).withCreateContainerCmdModifier(cmd -> cmd.withMemory(Long.valueOf(2122317824L)))).withExposedPorts(new Integer[]{7687, 7473, 7474})).withStartupAttempts(3)).withCreateContainerCmdModifier(cmd -> {
            try {
                Process p = Runtime.getRuntime().exec("id -u");
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String s = br.readLine();
                p.waitFor();
                p.destroy();
                cmd.withUser(s);
            }
            catch (Exception e) {
                System.out.println("Exception while assign cmd user to docker container:\n" + ExceptionUtils.getStackTrace((Throwable)e));
            }
        });
        if (withLogging) {
            neo4jContainer.withLogging();
        }
        return neo4jContainer.withWaitForNeo4jDatabaseReady(password, version);
    }

    public static void copyFilesToPlugin(File directory, IOFileFilter instance, File pluginsFolder) {
        Collection files = FileUtils.listFiles((File)directory, (IOFileFilter)instance, null);
        for (File file : files) {
            try {
                FileUtils.copyFileToDirectory((File)file, (File)pluginsFolder);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void executeGradleTasks(File baseDir, String ... tasks) {
        try (ProjectConnection connection = GradleConnector.newConnector().forProjectDirectory(baseDir).useBuildDistribution().connect();){
            BuildLauncher buildLauncher = connection.newBuild().forTasks(tasks);
            String neo4jVersionOverride = System.getenv("NEO4JVERSION");
            System.out.println("neo4jVersionOverride = " + neo4jVersionOverride);
            if (neo4jVersionOverride != null) {
                buildLauncher = (BuildLauncher)buildLauncher.addArguments(new String[]{"-P", "neo4jVersionOverride=" + neo4jVersionOverride});
            }
            String localMaven = System.getenv("LOCAL_MAVEN");
            System.out.println("localMaven = " + localMaven);
            if (localMaven != null) {
                buildLauncher = (BuildLauncher)buildLauncher.addArguments(new String[]{"-D", "maven.repo.local=" + localMaven});
            }
            buildLauncher.run();
        }
    }

    public static void testCall(Session session, String call, Map<String, Object> params, Consumer<Map<String, Object>> consumer) {
        TestContainerUtil.testResult(session, call, params, res -> {
            try {
                Assert.assertNotNull((String)"result should be not null", (Object)res);
                Assert.assertTrue((String)"result should be not empty", (boolean)res.hasNext());
                Map row = (Map)res.next();
                consumer.accept(row);
                Assert.assertFalse((String)"result should not have next", (boolean)res.hasNext());
            }
            catch (Throwable t) {
                TestUtil.printFullStackTrace(t);
                throw t;
            }
        });
    }

    public static void testCall(Session session, String call, Consumer<Map<String, Object>> consumer) {
        TestContainerUtil.testCall(session, call, null, consumer);
    }

    public static void testResult(Session session, String call, Consumer<Iterator<Map<String, Object>>> resultConsumer) {
        TestContainerUtil.testResult(session, call, null, resultConsumer);
    }

    public static void testResult(Session session, String call, Map<String, Object> params, Consumer<Iterator<Map<String, Object>>> resultConsumer) {
        session.writeTransaction(tx -> {
            Map p = params == null ? Collections.emptyMap() : params;
            resultConsumer.accept(tx.run(call, p).list().stream().map(Record::asMap).collect(Collectors.toList()).iterator());
            tx.commit();
            return null;
        });
    }

    public static void testCallEmpty(Session session, String call, Map<String, Object> params) {
        TestContainerUtil.testResult(session, call, params, res -> Assert.assertFalse((String)"Expected no results", (boolean)res.hasNext()));
    }

    public static void testCallInReadTransaction(Session session, String call, Map<String, Object> params, Consumer<Map<String, Object>> consumer) {
        TestContainerUtil.testResultInReadTransaction(session, call, params, res -> {
            try {
                Assert.assertNotNull((String)"result should be not null", (Object)res);
                Assert.assertTrue((String)"result should be not empty", (boolean)res.hasNext());
                Map row = (Map)res.next();
                consumer.accept(row);
                Assert.assertFalse((String)"result should not have next", (boolean)res.hasNext());
            }
            catch (Throwable t) {
                TestUtil.printFullStackTrace(t);
                throw t;
            }
        });
    }

    public static void testResultInReadTransaction(Session session, String call, Map<String, Object> params, Consumer<Iterator<Map<String, Object>>> resultConsumer) {
        session.readTransaction(tx -> {
            Map p = params == null ? Collections.emptyMap() : params;
            resultConsumer.accept(tx.run(call, p).list().stream().map(Record::asMap).collect(Collectors.toList()).iterator());
            tx.commit();
            return null;
        });
    }

    public static boolean isDockerImageAvailable(Exception ex) {
        Throwable cause = ex.getCause();
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)ex);
        return !(cause instanceof ContainerFetchException) || !(rootCause instanceof NotFoundException);
    }

    public static enum Neo4jVersion {
        ENTERPRISE,
        COMMUNITY;

    }

    public static enum ApocPackage {
        CORE,
        EXTENDED;

    }
}

