/*
 * Decompiled with CFR 0.152.
 */
package apoc.algo;

import apoc.util.collection.Iterables;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Result;

public class AlgoUtil {
    public static final String SETUP_GEO = "CREATE (b:City {name:'Berlin', coords: point({latitude:52.52464,longitude:13.40514}), lat:52.52464,lon:13.40514})\nCREATE (m:City {name:'M\u00fcnchen', coords: point({latitude:48.1374,longitude:11.5755, height: 1}), lat:48.1374,lon:11.5755})\nCREATE (f:City {name:'Frankfurt',coords: point({latitude:50.1167,longitude:8.68333, height: 1}), lat:50.1167,lon:8.68333})\nCREATE (h:City {name:'Hamburg', coords: point({latitude:53.554423,longitude:9.994583, height: 1}), lat:53.554423,lon:9.994583})\nCREATE (b)-[:DIRECT {dist:255.64*1000}]->(h)\nCREATE (b)-[:DIRECT {dist:504.47*1000}]->(m)\nCREATE (b)-[:DIRECT {dist:424.12*1000}]->(f)\nCREATE (f)-[:DIRECT {dist:304.28*1000}]->(m)\nCREATE (f)-[:DIRECT {dist:393.15*1000}]->(h)";

    public static void assertAStarResult(Result r) {
        Assert.assertEquals((Object)true, (Object)r.hasNext());
        Map row = r.next();
        Assert.assertEquals((long)697L, (long)(((Number)row.get("weight")).intValue() / 1000));
        Path path = (Path)row.get("path");
        Assert.assertEquals((long)2L, (long)path.length());
        List nodes = Iterables.asList((Iterable)path.nodes());
        Assert.assertEquals((Object)"M\u00fcnchen", (Object)((Node)nodes.get(0)).getProperty("name"));
        Assert.assertEquals((Object)"Frankfurt", (Object)((Node)nodes.get(1)).getProperty("name"));
        Assert.assertEquals((Object)"Hamburg", (Object)((Node)nodes.get(2)).getProperty("name"));
        Assert.assertEquals((Object)false, (Object)r.hasNext());
    }
}

