/*
 * Decompiled with CFR 0.152.
 */
package apoc.vectordb;

import apoc.vectordb.ChromaHandler;
import apoc.vectordb.MilvusHandler;
import apoc.vectordb.PineconeHandler;
import apoc.vectordb.QdrantHandler;
import apoc.vectordb.VectorEmbeddingHandler;
import apoc.vectordb.WeaviateHandler;
import java.util.HashMap;
import java.util.Map;

public interface VectorDbHandler {
    default public Map<String, Object> getCredentials(Object credentialsObj, Map<String, Object> config) {
        Map headers = config.getOrDefault("headers", new HashMap());
        headers.putIfAbsent("Authorization", "Bearer " + credentialsObj);
        config.put("headers", headers);
        return config;
    }

    public String getUrl(String var1);

    public VectorEmbeddingHandler getEmbedding();

    public String getLabel();

    public static enum Type {
        CHROMA(new ChromaHandler()),
        QDRANT(new QdrantHandler()),
        PINECONE(new PineconeHandler()),
        MILVUS(new MilvusHandler()),
        WEAVIATE(new WeaviateHandler());

        private final VectorDbHandler handler;

        private Type(VectorDbHandler handler) {
            this.handler = handler;
        }

        public VectorDbHandler get() {
            return this.handler;
        }
    }
}

