/*
 * Decompiled with CFR 0.152.
 */
package apoc.vectordb;

import apoc.Extended;
import apoc.ExtendedSystemPropertyKeys;
import apoc.SystemPropertyKeys;
import apoc.ml.RestAPIConfig;
import apoc.result.ObjectResult;
import apoc.util.ExtendedMapUtils;
import apoc.util.ExtendedUtil;
import apoc.util.JsonUtil;
import apoc.util.SystemDbUtil;
import apoc.util.Util;
import apoc.vectordb.VectorDbHandler;
import apoc.vectordb.VectorDbUtil;
import apoc.vectordb.VectorEmbeddingConfig;
import apoc.vectordb.VectorMappingConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.MultipleFoundException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.kernel.api.procedure.SystemProcedure;
import org.neo4j.procedure.Admin;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class VectorDb {
    @Context
    public URLAccessChecker urlAccessChecker;
    @Context
    public GraphDatabaseService db;
    @Context
    public Transaction tx;
    @Context
    public ProcedureCallContext procedureCallContext;

    @Procedure(value="apoc.vectordb.custom.get", mode=Mode.WRITE)
    @Description(value="apoc.vectordb.custom.get(host, $configuration) - Customizable get / query procedure, which retrieves vectors from the host and the configuration map")
    public Stream<VectorDbUtil.EmbeddingResult> get(@Name(value="host") String host, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        VectorDbUtil.getEndpoint(configuration, host);
        VectorEmbeddingConfig restAPIConfig = new VectorEmbeddingConfig(configuration);
        return VectorDb.getEmbeddingResultStream(restAPIConfig, this.procedureCallContext, this.urlAccessChecker, this.tx);
    }

    public static Stream<VectorDbUtil.EmbeddingResult> getEmbeddingResultStream(VectorEmbeddingConfig conf, ProcedureCallContext procedureCallContext, URLAccessChecker urlAccessChecker, Transaction tx) throws Exception {
        return VectorDb.getEmbeddingResultStream(conf, procedureCallContext, urlAccessChecker, tx, v -> ((List)v).stream());
    }

    public static Stream<VectorDbUtil.EmbeddingResult> getEmbeddingResultStream(VectorEmbeddingConfig conf, ProcedureCallContext procedureCallContext, URLAccessChecker urlAccessChecker, Transaction tx, Function<Object, Stream<Map>> objectMapper) throws Exception {
        List fields = procedureCallContext.outputFields().toList();
        boolean hasVector = fields.contains("vector") && conf.isAllResults();
        boolean hasMetadata = fields.contains("metadata");
        VectorMappingConfig mapping = conf.getMapping();
        return VectorDb.executeRequest(conf.getApiConfig(), urlAccessChecker).flatMap(objectMapper).map(m -> VectorDb.getEmbeddingResult(conf, tx, hasVector, hasMetadata, mapping, m));
    }

    public static VectorDbUtil.EmbeddingResult getEmbeddingResult(VectorEmbeddingConfig conf, Transaction tx, boolean hasEmbedding, boolean hasMetadata, VectorMappingConfig mapping, Map m) {
        Object id = conf.isAllResults() ? m.get(conf.getIdKey()) : null;
        List embedding = hasEmbedding ? (List)m.get(conf.getVectorKey()) : null;
        Map metadata = hasMetadata ? (Map)m.get(conf.getMetadataKey()) : null;
        Double score = Util.toDouble(m.get(conf.getScoreKey()));
        String text = conf.isAllResults() ? (String)m.get(conf.getTextKey()) : null;
        Entity entity = VectorDb.handleMapping(tx, mapping, metadata, embedding);
        if (entity != null) {
            entity = Util.rebind((Transaction)tx, (Entity)entity);
        }
        return new VectorDbUtil.EmbeddingResult(id, score, embedding, metadata, text, mapping.getNodeLabel() == null ? null : (Node)entity, mapping.getNodeLabel() != null ? null : (Relationship)entity);
    }

    private static Entity handleMapping(Transaction tx, VectorMappingConfig mapping, Map<String, Object> metadata, List<Double> embedding) {
        if (mapping.getEntityKey() == null) {
            return null;
        }
        if (ExtendedMapUtils.isEmpty(metadata)) {
            throw new RuntimeException("To use mapping config, the metadata should not be empty. Make sure you execute `YIELD metadata` on the procedure");
        }
        HashMap<String, Object> metaProps = new HashMap<String, Object>(metadata);
        if (mapping.getNodeLabel() != null) {
            return VectorDb.handleMappingNode(tx, mapping, metaProps, embedding);
        }
        if (mapping.getRelType() != null) {
            return VectorDb.handleMappingRel(tx, mapping, metaProps, embedding);
        }
        throw new RuntimeException("Mapping conf has to contain either label or type key");
    }

    private static Entity handleMappingNode(Transaction transaction, VectorMappingConfig mapping, Map<String, Object> metaProps, List<Double> embedding) {
        try {
            Object propValue = metaProps.get(mapping.getMetadataKey());
            Node node = transaction.findNode(Label.label((String)mapping.getNodeLabel()), mapping.getEntityKey(), propValue);
            switch (mapping.getMode()) {
                case READ_ONLY: {
                    break;
                }
                case UPDATE_EXISTING: {
                    VectorDb.setPropsIfEntityExists(mapping, metaProps, embedding, (Entity)node);
                    break;
                }
                case CREATE_IF_MISSING: {
                    if (node == null) {
                        node = transaction.createNode(new Label[]{Label.label((String)mapping.getNodeLabel())});
                        node.setProperty(mapping.getEntityKey(), propValue);
                    }
                    VectorDb.setPropsIfEntityExists(mapping, metaProps, embedding, (Entity)node);
                }
            }
            return node;
        }
        catch (MultipleFoundException e) {
            throw new RuntimeException("Multiple nodes found");
        }
    }

    private static Entity handleMappingRel(Transaction transaction, VectorMappingConfig mapping, Map<String, Object> metaProps, List<Double> embedding) {
        try {
            Object propValue = metaProps.get(mapping.getMetadataKey());
            Relationship rel = transaction.findRelationship(RelationshipType.withName((String)mapping.getRelType()), mapping.getEntityKey(), propValue);
            switch (mapping.getMode()) {
                case READ_ONLY: {
                    break;
                }
                case UPDATE_EXISTING: 
                case CREATE_IF_MISSING: {
                    VectorDb.setPropsIfEntityExists(mapping, metaProps, embedding, (Entity)rel);
                }
            }
            return rel;
        }
        catch (MultipleFoundException e) {
            throw new RuntimeException("Multiple relationships found");
        }
    }

    private static void setPropsIfEntityExists(VectorMappingConfig mapping, Map<String, Object> metaProps, List<Double> embedding, Entity entity) {
        if (entity != null) {
            ExtendedUtil.setProperties(entity, metaProps);
            VectorDb.setVectorProp(mapping, embedding, entity);
        }
    }

    private static <T extends Entity> void setVectorProp(VectorMappingConfig mapping, List<Double> embedding, T entity) {
        if (mapping.getEmbeddingKey() == null) {
            return;
        }
        if (embedding == null) {
            String embeddingErrMsg = "The embedding value is null. Make sure you execute `YIELD embedding` on the procedure and you configured `%s: true`".formatted("allResults");
            throw new RuntimeException(embeddingErrMsg);
        }
        float[] floats = ExtendedUtil.listOfNumbersToFloatArray(embedding);
        entity.setProperty(mapping.getEmbeddingKey(), (Object)floats);
    }

    @Procedure(value="apoc.vectordb.custom")
    @Description(value="apoc.vectordb.custom(host, $configuration) - fully customizable procedure, returns generic object results")
    public Stream<ObjectResult> custom(@Name(value="host") String host, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        VectorDbUtil.getEndpoint(configuration, host);
        RestAPIConfig restAPIConfig = new RestAPIConfig(configuration);
        return VectorDb.executeRequest(restAPIConfig, this.urlAccessChecker).map(ObjectResult::new);
    }

    public static Stream<Object> executeRequest(RestAPIConfig apiConfig, URLAccessChecker urlAccessChecker) throws Exception {
        Map<String, Object> headers = apiConfig.getHeaders();
        Map<String, Object> configBody = apiConfig.getBody();
        String body = configBody == null ? null : JsonUtil.OBJECT_MAPPER.writeValueAsString(configBody);
        String endpoint = apiConfig.getEndpoint();
        if (endpoint == null) {
            throw new RuntimeException("Endpoint must be specified");
        }
        return JsonUtil.loadJson((Object)endpoint, headers, (String)body, (String)apiConfig.getJsonPath(), (boolean)true, List.of(), (URLAccessChecker)urlAccessChecker);
    }

    @Admin
    @SystemProcedure
    @Procedure(name="apoc.vectordb.configure")
    @Description(value="CALL apoc.vectordb.configure(vectorName, host, credentialsValue, mapping) - To configure, given the vector defined by the 1st parameter, `host`, `credentials` and `mapping` into the system db")
    public void vectordb(@Name(value="vectorName") String vectorName, @Name(value="configKey") String configKey, @Name(value="databaseName") String databaseName, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        SystemDbUtil.checkInSystemLeader(this.db);
        SystemDbUtil.checkTargetDatabase(this.tx, databaseName, "Vector DB configuration");
        VectorDbHandler.Type type = VectorDbHandler.Type.valueOf(vectorName.toUpperCase());
        SystemDbUtil.withSystemDb(transaction -> {
            Label label = Label.label((String)type.get().getLabel());
            Node node = Util.mergeNode((Transaction)transaction, (Label)label, null, (Pair[])new Pair[]{Pair.of((Object)SystemPropertyKeys.name.name(), (Object)configKey)});
            Map mapping = (Map)config.get("mapping");
            String host = VectorDbUtil.appendVersionUrlIfNeeded(type, (String)config.get("host"));
            Object credentials = config.get("credentials");
            if (host != null) {
                node.setProperty(ExtendedSystemPropertyKeys.host.name(), (Object)host);
            }
            if (credentials != null) {
                node.setProperty(ExtendedSystemPropertyKeys.credentials.name(), (Object)Util.toJson(credentials));
            }
            if (mapping != null) {
                node.setProperty("mapping", (Object)Util.toJson((Object)mapping));
            }
        });
    }
}

