/*
 * Decompiled with CFR 0.152.
 */
package apoc.vectordb;

import apoc.util.MapUtil;
import apoc.util.UrlResolver;
import apoc.vectordb.VectorDbHandler;
import apoc.vectordb.VectorEmbeddingConfig;
import apoc.vectordb.VectorEmbeddingHandler;
import java.util.List;
import java.util.Map;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;

public class QdrantHandler
implements VectorDbHandler {
    @Override
    public String getUrl(String hostOrKey) {
        return new UrlResolver("http", "localhost", 6333).getUrl("qdrant", hostOrKey);
    }

    @Override
    public VectorEmbeddingHandler getEmbedding() {
        return new QdrantEmbeddingHandler();
    }

    @Override
    public String getLabel() {
        return "Qdrant";
    }

    static class QdrantEmbeddingHandler
    implements VectorEmbeddingHandler {
        QdrantEmbeddingHandler() {
        }

        @Override
        public <T> VectorEmbeddingConfig fromGet(Map<String, Object> config, ProcedureCallContext procedureCallContext, List<T> ids, String collection) {
            List<String> fields = procedureCallContext.outputFields().toList();
            config.putIfAbsent("method", "POST");
            Map additionalBodies = MapUtil.map((Object[])new Object[]{"ids", ids});
            return this.getVectorEmbeddingConfig(config, fields, additionalBodies);
        }

        @Override
        public VectorEmbeddingConfig fromQuery(Map<String, Object> config, ProcedureCallContext procedureCallContext, List<Double> vector, Object filter, long limit, String collection) {
            List<String> fields = procedureCallContext.outputFields().toList();
            Map additionalBodies = MapUtil.map((Object[])new Object[]{"vector", vector, "filter", filter, "limit", limit});
            return this.getVectorEmbeddingConfig(config, fields, additionalBodies);
        }

        private VectorEmbeddingConfig getVectorEmbeddingConfig(Map<String, Object> config, List<String> fields, Map<String, Object> additionalBodies) {
            config.putIfAbsent("vectorKey", "vector");
            config.putIfAbsent("metadataKey", "payload");
            config.putIfAbsent("jsonPath", "result");
            VectorEmbeddingConfig conf = new VectorEmbeddingConfig(config);
            additionalBodies.put("with_payload", fields.contains("metadata"));
            additionalBodies.put("with_vectors", fields.contains("vector") && conf.isAllResults());
            return this.populateApiBodyRequest(conf, additionalBodies);
        }
    }
}

