/*
 * Decompiled with CFR 0.152.
 */
package apoc.vectordb;

import apoc.util.MapUtil;
import apoc.util.UrlResolver;
import apoc.vectordb.VectorDbHandler;
import apoc.vectordb.VectorDbUtil;
import apoc.vectordb.VectorEmbeddingConfig;
import apoc.vectordb.VectorEmbeddingHandler;
import java.util.List;
import java.util.Map;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;

public class MilvusHandler
implements VectorDbHandler {
    @Override
    public String getUrl(String hostOrKey) {
        String url = new UrlResolver("http", "localhost", 19530).getUrl("milvus", hostOrKey);
        return url + "/v2/vectordb";
    }

    @Override
    public VectorEmbeddingHandler getEmbedding() {
        return new MilvusEmbeddingHandler();
    }

    @Override
    public String getLabel() {
        return "Milvus";
    }

    static class MilvusEmbeddingHandler
    implements VectorEmbeddingHandler {
        MilvusEmbeddingHandler() {
        }

        @Override
        public <T> VectorEmbeddingConfig fromGet(Map<String, Object> config, ProcedureCallContext procedureCallContext, List<T> ids, String collection) {
            List<String> fields = procedureCallContext.outputFields().toList();
            Map additionalBodies = MapUtil.map((Object[])new Object[]{"id", ids});
            return this.getVectorEmbeddingConfig(config, fields, collection, additionalBodies);
        }

        @Override
        public VectorEmbeddingConfig fromQuery(Map<String, Object> config, ProcedureCallContext procedureCallContext, List<Double> vector, Object filter, long limit, String collection) {
            config.putIfAbsent("scoreKey", "distance");
            List<String> fields = procedureCallContext.outputFields().toList();
            Map additionalBodies = MapUtil.map((Object[])new Object[]{"data", List.of(vector), "limit", limit});
            if (filter != null) {
                additionalBodies.put("filter", filter);
            }
            return this.getVectorEmbeddingConfig(config, fields, collection, additionalBodies);
        }

        private VectorEmbeddingConfig getVectorEmbeddingConfig(Map<String, Object> config, List<String> procFields, String collection, Map<String, Object> additionalBodies) {
            config.putIfAbsent("metaAsSubKey", false);
            List listFields = VectorDbUtil.addMetadataKeyToFields(config);
            if (procFields.contains("vector") && !listFields.contains("vector")) {
                listFields.add("vector");
            }
            VectorEmbeddingConfig conf = new VectorEmbeddingConfig(config);
            additionalBodies.put("collectionName", collection);
            additionalBodies.put("outputFields", listFields);
            return this.populateApiBodyRequest(conf, additionalBodies);
        }
    }
}

