/*
 * Decompiled with CFR 0.152.
 */
package apoc.uuid;

import apoc.Extended;
import apoc.ExtendedApocConfig;
import apoc.Pools;
import apoc.util.SystemDbUtil;
import apoc.util.Util;
import apoc.uuid.UuidConfig;
import apoc.uuid.UuidHandler;
import apoc.uuid.UuidInfo;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class Uuid {
    private static final String MSG_DEPRECATION = "Please note that the current procedure is deprecated, \nit's recommended to use the `apoc.uuid.setup`, `apoc.uuid.drop`, `apoc.uuid.dropAll` procedures executed against the 'system' database \ninstead of, respectively, `apoc.uuid.install`, `apoc.uuid.remove`, `apoc.uuid.removeAll`.";
    @Context
    public GraphDatabaseService db;
    @Context
    public Pools pools;
    @Context
    public UuidHandler uuidHandler;
    @Context
    public Transaction tx;

    @Deprecated
    @Procedure(mode=Mode.WRITE, deprecatedBy="apoc.uuid.setup")
    @Description(value="CALL apoc.uuid.install(label, {addToExistingNodes: true/false, uuidProperty: 'uuid'}) yield label, installed, properties, batchComputationResult | it will add the uuid transaction handler\nfor the provided `label` and `uuidProperty`, in case the UUID handler is already present it will be replaced by the new one")
    public Stream<UuidInstallInfo> install(@Name(value="label") String label, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        SystemDbUtil.checkWriteAllowed(MSG_DEPRECATION);
        UuidConfig uuidConfig = new UuidConfig(config);
        this.uuidHandler.checkConstraintUuid(this.tx, label, uuidConfig.getUuidProperty());
        Map<String, Object> addToExistingNodesResult = Collections.emptyMap();
        if (uuidConfig.isAddToExistingNodes()) {
            try {
                addToExistingNodesResult = Uuid.setExistingNodes(this.db, this.pools, label, uuidConfig);
            }
            catch (RuntimeException e) {
                if (e.getMessage().contains("There is no procedure with the name `apoc.periodic.iterate` registered for this database instance")) {
                    throw new RuntimeException("apoc core needs to be installed when using apoc.uuid.install with the flag addToExistingNodes = true");
                }
                throw e;
            }
        }
        this.uuidHandler.add(this.tx, label, uuidConfig);
        return Stream.of(new UuidInstallInfo(label, true, Map.of("uuidProperty", uuidConfig.getUuidProperty(), "addToSetLabels", uuidConfig.isAddToSetLabels()), addToExistingNodesResult));
    }

    @Deprecated
    @Procedure(mode=Mode.WRITE, deprecatedBy="apoc.uuid.drop")
    @Description(value="CALL apoc.uuid.remove(label) yield label, installed, properties | remove previously added uuid handler and returns uuid information. All the existing uuid properties are left as-is")
    public Stream<UuidInfo> remove(@Name(value="label") String label) {
        SystemDbUtil.checkWriteAllowed(MSG_DEPRECATION);
        UuidConfig removed = this.uuidHandler.remove(label);
        if (removed == null) {
            return Stream.of(new UuidInfo(false));
        }
        return Stream.of(new UuidInfo(label, false, Map.of("uuidProperty", removed.getUuidProperty(), "addToSetLabels", removed.isAddToSetLabels())));
    }

    @Deprecated
    @Procedure(mode=Mode.WRITE, deprecatedBy="apoc.uuid.dropAll")
    @Description(value="CALL apoc.uuid.removeAll() yield label, installed, properties | it removes all previously added uuid handlers and returns uuids information. All the existing uuid properties are left as-is")
    public Stream<UuidInfo> removeAll() {
        SystemDbUtil.checkWriteAllowed(MSG_DEPRECATION);
        Map<String, UuidConfig> removed = this.uuidHandler.removeAll();
        if (removed == null) {
            return Stream.of(new UuidInfo(false));
        }
        return removed.entrySet().stream().map(e -> {
            UuidConfig conf = (UuidConfig)e.getValue();
            return new UuidInfo((String)e.getKey(), false, Map.of("uuidProperty", conf.getUuidProperty(), "addToSetLabels", conf.isAddToSetLabels()));
        });
    }

    @Procedure(mode=Mode.READ)
    @Description(value="CALL apoc.uuid.list() yield label, installed, properties | provides a list of all the uuid handlers installed with the related configuration")
    public Stream<UuidInfo> list() {
        return this.uuidHandler.list().entrySet().stream().map(e -> {
            UuidConfig conf = (UuidConfig)e.getValue();
            return new UuidInfo((String)e.getKey(), true, Map.of("uuidProperty", conf.getUuidProperty(), "addToSetLabels", conf.isAddToSetLabels()));
        });
    }

    public static Map<String, Object> setExistingNodes(GraphDatabaseService db, Pools pools, String label, UuidConfig uuidConfig) {
        String uuidFunctionName = Uuid.getUuidFunctionName();
        return (Map)Util.inTx((GraphDatabaseService)db, (Pools)pools, txInThread -> {
            String iterate = "MATCH (n:" + Uuid.sanitizeAndQuote(label) + ") RETURN id(n) AS id";
            String action = "MATCH (n) WHERE id(n) = id SET n." + Uuid.sanitizeAndQuote(uuidConfig.getUuidProperty()) + " = " + uuidFunctionName + "()";
            return txInThread.execute("CALL apoc.periodic.iterate($iterate, $action, {batchSize:10000, parallel:true})", Map.of("iterate", iterate, "action", action)).next();
        });
    }

    public static String getUuidFunctionName() {
        ExtendedApocConfig.UuidFormatType formatType = ExtendedApocConfig.extendedApocConfig().getEnumProperty("apoc.uuid.format", ExtendedApocConfig.UuidFormatType.class, ExtendedApocConfig.UuidFormatType.hex);
        switch (formatType) {
            case base64: {
                return "apoc.create.uuidBase64";
            }
        }
        return "apoc.create.uuid";
    }

    private static String sanitizeAndQuote(String var) {
        return Util.quote((String)var.replaceAll("`", ""));
    }

    public static class UuidInstallInfo
    extends UuidInfo {
        public Map<String, Object> batchComputationResult;

        UuidInstallInfo(String label, boolean installed, Map<String, Object> properties, Map<String, Object> batchComputationResult) {
            super(label, installed, properties);
            this.batchComputationResult = batchComputationResult;
        }
    }
}

