/*
 * Decompiled with CFR 0.152.
 */
package apoc.uuid;

import apoc.ApocConfig;
import apoc.Extended;
import apoc.util.SystemDbUtil;
import apoc.uuid.UUIDHandlerNewProcedures;
import apoc.uuid.UuidConfig;
import apoc.uuid.UuidInfo;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.procedure.SystemProcedure;
import org.neo4j.procedure.Admin;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class UUIDNewProcedures {
    public static final String UUID_NOT_SET = "apoc.uuid.refresh is not set. Please please set it in your apoc.conf";
    @Context
    public GraphDatabaseService db;
    @Context
    public Transaction tx;

    private void checkInSystemLeader(String databaseName) {
        UUIDHandlerNewProcedures.checkEnabled(databaseName);
        this.checkRefreshConfigSet();
        SystemDbUtil.checkInSystemLeader(this.db);
    }

    private void checkTargetDatabase(String databaseName) {
        SystemDbUtil.checkTargetDatabase(this.tx, databaseName, "Automatic UUIDs");
    }

    private void checkRefreshConfigSet() {
        if (!ApocConfig.apocConfig().getConfig().containsKey("apoc.uuid.refresh")) {
            throw new RuntimeException(UUID_NOT_SET);
        }
    }

    @SystemProcedure
    @Admin
    @Procedure(mode=Mode.WRITE)
    @Description(value="CALL apoc.uuid.setup(label, databaseName, $config) | eventually adds the uuid transaction handler for the provided `label` and `uuidProperty`, in case the UUID handler is already present it will be replaced by the new one")
    public Stream<UuidInfo> setup(@Name(value="label") String label, @Name(value="databaseName", defaultValue="neo4j") String databaseName, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        this.checkInSystemLeader(databaseName);
        this.checkTargetDatabase(databaseName);
        UuidConfig uuidConfig = new UuidConfig(config);
        UuidInfo uuidInfo = UUIDHandlerNewProcedures.create(databaseName, label, uuidConfig);
        return Stream.of(uuidInfo);
    }

    @SystemProcedure
    @Admin
    @Procedure(mode=Mode.WRITE)
    @Description(value="CALL apoc.uuid.drop(label, databaseName) yield label, installed, properties | eventually removes previously added UUID handler and returns uuid information")
    public Stream<UuidInfo> drop(@Name(value="label") String label, @Name(value="databaseName", defaultValue="neo4j") String databaseName) {
        this.checkInSystemLeader(databaseName);
        UuidInfo uuidInfo = UUIDHandlerNewProcedures.drop(databaseName, label);
        return Stream.ofNullable(uuidInfo);
    }

    @SystemProcedure
    @Admin
    @Procedure(mode=Mode.WRITE)
    @Description(value="CALL apoc.uuid.dropAll(databaseName) yield label, installed, properties | eventually removes all previously added UUID handlers and returns uuids' information")
    public Stream<UuidInfo> dropAll(@Name(value="databaseName", defaultValue="neo4j") String databaseName) {
        this.checkInSystemLeader(databaseName);
        return UUIDHandlerNewProcedures.dropAll(databaseName).stream().sorted(Comparator.comparing(i -> i.label));
    }

    @SystemProcedure
    @Admin
    @Procedure(mode=Mode.READ)
    @Description(value="CALL apoc.uuid.show(databaseName) | it lists all eventually installed UUID handler for a database")
    public Stream<UuidInfo> show(@Name(value="databaseName", defaultValue="neo4j") String databaseName) {
        UUIDHandlerNewProcedures.checkEnabled(databaseName);
        return SystemDbUtil.withSystemDb(sysTx -> UUIDHandlerNewProcedures.getUuidNodes(sysTx, databaseName).stream().map(UuidInfo::new).collect(Collectors.toList())).stream();
    }
}

