/*
 * Decompiled with CFR 0.152.
 */
package apoc.ttl;

import apoc.TTLConfig;
import apoc.util.Util;
import apoc.util.collection.Iterators;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;

public class TTLLifeCycle
extends LifecycleAdapter {
    private static final Group TTL_GROUP = Group.INDEX_UPDATING;
    private final JobScheduler scheduler;
    private final GraphDatabaseAPI db;
    private JobHandle ttlIndexJobHandle;
    private JobHandle ttlJobHandle;
    private final TTLConfig ttlConfig;
    private final Log log;

    public TTLLifeCycle(JobScheduler scheduler, GraphDatabaseAPI db, TTLConfig ttlConfig, Log log) {
        this.scheduler = scheduler;
        this.db = db;
        this.ttlConfig = ttlConfig;
        this.log = log;
    }

    public void start() {
        TTLConfig.Values configValues = this.ttlConfig.configFor(this.db);
        if (configValues.enabled) {
            long ttlScheduleDb = configValues.schedule;
            this.ttlIndexJobHandle = this.scheduler.schedule(TTL_GROUP, this::createTTLIndex, (long)((int)((double)ttlScheduleDb * 0.8)), TimeUnit.SECONDS);
            long limitDb = configValues.limit;
            this.ttlJobHandle = this.scheduler.scheduleRecurring(TTL_GROUP, () -> this.expireNodes(limitDb), ttlScheduleDb, ttlScheduleDb, TimeUnit.SECONDS);
        }
    }

    public void expireNodes(long limit) {
        try {
            if (!Util.isWriteableInstance((GraphDatabaseAPI)this.db)) {
                return;
            }
            String matchTTL = "MATCH (t:TTL) WHERE t.ttl < timestamp() ";
            String queryRels = "MATCH (t:TTL) WHERE t.ttl < timestamp() WITH t MATCH (t)-[r]-() WITH r LIMIT $limit DELETE r RETURN r";
            String queryNodes = "MATCH (t:TTL) WHERE t.ttl < timestamp() WITH t LIMIT $limit DETACH DELETE t RETURN t";
            long relationshipsDeleted = this.deleteEntities(limit, "MATCH (t:TTL) WHERE t.ttl < timestamp() WITH t MATCH (t)-[r]-() WITH r LIMIT $limit DELETE r RETURN r");
            long nodesDeleted = this.deleteEntities(limit, "MATCH (t:TTL) WHERE t.ttl < timestamp() WITH t LIMIT $limit DETACH DELETE t RETURN t");
            if (nodesDeleted > 0L) {
                this.log.info("TTL: Expired %d nodes %d relationships", new Object[]{nodesDeleted, relationshipsDeleted});
            }
        }
        catch (Exception e) {
            this.log.error("TTL: Error deleting expired nodes", (Throwable)e);
        }
    }

    private long deleteEntities(long limit, String query) {
        return this.deleteEntities(limit, query, 0L);
    }

    private long deleteEntities(long limit, String query, long deleted) {
        long currDeleted = (Long)this.db.executeTransactionally(query, Map.of("limit", limit), Iterators::count);
        if (currDeleted > 0L) {
            return this.deleteEntities(limit, query, deleted += currDeleted);
        }
        return deleted;
    }

    public void createTTLIndex() {
        try {
            this.db.executeTransactionally("CREATE INDEX IF NOT EXISTS FOR (n:TTL) ON (n.ttl)");
        }
        catch (Exception e) {
            this.log.error("TTL: Error creating index", (Throwable)e);
        }
    }

    public void stop() {
        if (this.ttlIndexJobHandle != null) {
            this.ttlIndexJobHandle.cancel();
        }
        if (this.ttlJobHandle != null) {
            this.ttlJobHandle.cancel();
        }
    }
}

