/*
 * Decompiled with CFR 0.152.
 */
package apoc.systemdb.metadata;

import apoc.ExtendedSystemPropertyKeys;
import apoc.export.util.ProgressReporter;
import apoc.systemdb.metadata.ExportMetadata;
import apoc.util.ExtendedUtil;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.graphdb.Node;

public class ExportUuid
implements ExportMetadata {
    @Override
    public List<Pair<String, String>> export(Node node, ProgressReporter progressReporter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String labelName = (String)node.getProperty(ExtendedSystemPropertyKeys.label.name());
        String property = (String)node.getProperty(ExtendedSystemPropertyKeys.propertyName.name());
        map.put("addToSetLabels", node.getProperty(ExtendedSystemPropertyKeys.addToSetLabel.name(), null));
        map.put("uuidProperty", property);
        String uuidConfig = ExtendedUtil.toCypherMap(map);
        String schemaStatement = String.format("CREATE CONSTRAINT %1$s_%2$s IF NOT EXISTS FOR (n:%1$s) REQUIRE n.%2$s IS UNIQUE;\n", labelName, property);
        String statement = String.format("CALL apoc.uuid.install('%s', %s);", labelName, uuidConfig);
        progressReporter.nextRow();
        return List.of(Pair.of((Object)this.getFileName(node, ExportMetadata.Type.Uuid.name() + ".schema"), (Object)schemaStatement), Pair.of((Object)this.getFileName(node, ExportMetadata.Type.Uuid.name()), (Object)statement));
    }
}

