/*
 * Decompiled with CFR 0.152.
 */
package apoc.redis;

import apoc.redis.ByteArrayRedisConnection;
import apoc.redis.RedisConnection;
import apoc.redis.StringRedisConnection;
import apoc.util.MissingDependencyException;
import apoc.util.Util;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;

public class RedisConfig {
    public static final String REDIS_MISSING_DEPS_ERROR = "Cannot find the Redis client jar.\nPlease put the apoc-redis-dependencies-5.x.x-all.jar into plugin folder.\nSee the documentation: https://neo4j.com/labs/apoc/5/database-integration/redis/#redis-dependencies";
    private final Charset charset;
    private final Duration timeout;
    private final boolean autoReconnect;
    private final boolean right;
    private final Charset scriptCharset;
    private final Codec codec;

    public RedisConfig(Map<String, Object> config) {
        if (config == null) {
            config = Collections.emptyMap();
        }
        this.charset = Charset.forName((String)config.getOrDefault("charset", "UTF-8"));
        this.timeout = Duration.ofSeconds((Long)config.getOrDefault("timeout", 60L));
        this.scriptCharset = Charset.forName((String)config.getOrDefault("scriptCharset", "UTF-8"));
        this.autoReconnect = Util.toBoolean((Object)config.getOrDefault("autoReconnect", true));
        this.right = Util.toBoolean((Object)config.getOrDefault("right", true));
        this.codec = Codec.valueOf(config.getOrDefault("codec", Codec.STRING.name()).toString().toUpperCase());
    }

    public boolean isRight() {
        return this.right;
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public Charset getScriptCharset() {
        return this.scriptCharset;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public static enum Codec {
        STRING(StringRedisConnection.class),
        BYTE_ARRAY(ByteArrayRedisConnection.class);

        private Class<? extends RedisConnection> redisConnectionClass;

        private Codec(Class<? extends RedisConnection> redisConnectionClass) {
            this.redisConnectionClass = redisConnectionClass;
        }

        public RedisConnection getRedisConnection(String uri, Map<String, Object> config) {
            try {
                RedisConfig redisConfig = new RedisConfig(config);
                Constructor<? extends RedisConnection> constructor = this.redisConnectionClass.getConstructor(String.class, RedisConfig.class);
                return constructor.newInstance(uri, redisConfig);
            }
            catch (NoClassDefFoundError e) {
                throw new MissingDependencyException(RedisConfig.REDIS_MISSING_DEPS_ERROR);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

