/*
 * Decompiled with CFR 0.152.
 */
package apoc.nlp.gcp;

import apoc.nlp.gcp.GCPClient;
import apoc.nlp.gcp.GCPEndpoint;
import apoc.result.NodeValueErrorMapResult;
import apoc.util.JsonUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.neo4j.graphdb.Node;
import org.neo4j.logging.Log;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00032\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J&\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00032\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J&\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00032\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lapoc/nlp/gcp/RealGCPClient;", "Lapoc/nlp/gcp/GCPClient;", "config", "", "", "", "log", "Lorg/neo4j/logging/Log;", "(Ljava/util/Map;Lorg/neo4j/logging/Log;)V", "apiKey", "baseUrl", "nodeProperty", "classify", "", "Lapoc/result/NodeValueErrorMapResult;", "nodes", "Lorg/neo4j/graphdb/Node;", "batchId", "", "convertInput", "data", "entities", "postData", "url", "Ljava/net/URL;", "method", "Companion", "apoc"})
@SourceDebugExtension(value={"SMAP\nRealGCPClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealGCPClient.kt\napoc/nlp/gcp/RealGCPClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1#2:65\n1549#3:66\n1620#3,3:67\n1549#3:70\n1620#3,3:71\n*S KotlinDebug\n*F\n+ 1 RealGCPClient.kt\napoc/nlp/gcp/RealGCPClient\n*L\n53#1:66\n53#1:67,3\n57#1:70\n57#1:71,3\n*E\n"})
public final class RealGCPClient
implements GCPClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Log log;
    @NotNull
    private final String baseUrl;
    @NotNull
    private final String apiKey;
    @NotNull
    private final String nodeProperty;
    @NotNull
    private static final ObjectMapper MAPPER;

    public RealGCPClient(@NotNull Map<String, ? extends Object> config, @NotNull Log log) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.log = log;
        this.baseUrl = "https://language.googleapis.com/v1";
        this.apiKey = String.valueOf(config.get("key"));
        this.nodeProperty = config.getOrDefault("nodeProperty", "text").toString();
    }

    private final Map<String, Object> postData(String method, String data) {
        String fullUrl = this.baseUrl + method + "?key=" + this.apiKey;
        URL url = new URL(fullUrl);
        return this.postData(url, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, Object> postData(URL url, String data) {
        Object it2;
        URLConnection uRLConnection = url.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
        HttpsURLConnection connection = (HttpsURLConnection)uRLConnection;
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/json");
        Closeable closeable = new DataOutputStream(connection.getOutputStream());
        Throwable throwable = null;
        try {
            it2 = (DataOutputStream)closeable;
            boolean bl = false;
            ((FilterOutputStream)it2).write(MAPPER.writeValueAsBytes((Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"document", this.convertInput(data)))));
            it2 = Unit.INSTANCE;
        }
        catch (Throwable it2) {
            throwable = it2;
            throw it2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        closeable = connection.getInputStream();
        throwable = null;
        try {
            it2 = (InputStream)closeable;
            boolean bl = false;
            it2 = MAPPER.readValue((InputStream)it2, Object.class);
        }
        catch (Throwable it3) {
            throwable = it3;
            throw it3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Object result = it2;
        boolean bl = false;
        Intrinsics.checkNotNull((Object)result, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
        return (Map)result;
    }

    private final Map<String, Object> convertInput(String data) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"PLAIN_TEXT"), TuplesKt.to((Object)"content", (Object)data)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<NodeValueErrorMapResult> entities(@NotNull List<? extends Node> nodes, int batchId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Iterable $this$map$iv = nodes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void node;
            Node node2 = (Node)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(NodeValueErrorMapResult.withResult((Node)node, this.postData(GCPEndpoint.ENTITIES.getMethod(), node.getProperty(this.nodeProperty).toString())));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<NodeValueErrorMapResult> classify(@NotNull List<? extends Node> nodes, int batchId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Iterable $this$map$iv = nodes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void node;
            Node node2 = (Node)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(NodeValueErrorMapResult.withResult((Node)node, this.postData(GCPEndpoint.CLASSIFY.getMethod(), node.getProperty(this.nodeProperty).toString())));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final ObjectMapper getMAPPER() {
        return Companion.getMAPPER();
    }

    static {
        ObjectMapper objectMapper = JsonUtil.OBJECT_MAPPER;
        Intrinsics.checkNotNull((Object)objectMapper);
        MAPPER = objectMapper;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lapoc/nlp/gcp/RealGCPClient$Companion;", "", "()V", "MAPPER", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMAPPER$annotations", "getMAPPER", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "apoc"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ObjectMapper getMAPPER() {
            return MAPPER;
        }

        @JvmStatic
        public static /* synthetic */ void getMAPPER$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

