/*
 * Decompiled with CFR 0.152.
 */
package apoc.nlp.aws;

import apoc.nlp.aws.AWSClient;
import apoc.result.MapResult;
import apoc.util.JsonUtil;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.comprehend.AmazonComprehend;
import com.amazonaws.services.comprehend.AmazonComprehendClientBuilder;
import com.amazonaws.services.comprehend.model.BatchDetectEntitiesRequest;
import com.amazonaws.services.comprehend.model.BatchDetectEntitiesResult;
import com.amazonaws.services.comprehend.model.BatchDetectKeyPhrasesItemResult;
import com.amazonaws.services.comprehend.model.BatchDetectKeyPhrasesRequest;
import com.amazonaws.services.comprehend.model.BatchDetectKeyPhrasesResult;
import com.amazonaws.services.comprehend.model.BatchDetectSentimentItemResult;
import com.amazonaws.services.comprehend.model.BatchDetectSentimentRequest;
import com.amazonaws.services.comprehend.model.BatchDetectSentimentResult;
import com.amazonaws.services.comprehend.model.BatchItemError;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphdb.Node;
import org.neo4j.logging.Log;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0001$B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0015H\u0002J \u0010\u0018\u001a\u0004\u0018\u00010\u00192\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010\u001e\u001a\u0004\u0018\u00010\u001f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J0\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00152\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003J \u0010!\u001a\u0004\u0018\u00010\"2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J0\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00152\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003J*\u0010#\u001a\b\u0012\u0004\u0012\u00020 0\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lapoc/nlp/aws/RealAWSClient;", "Lapoc/nlp/aws/AWSClient;", "config", "", "", "", "log", "Lorg/neo4j/logging/Log;", "(Ljava/util/Map;Lorg/neo4j/logging/Log;)V", "apiKey", "apiSecret", "apiSessionToken", "awsClient", "Lcom/amazonaws/services/comprehend/AmazonComprehend;", "kotlin.jvm.PlatformType", "language", "nodeProperty", "region", "awsStaticCredentialsProvider", "Lcom/amazonaws/auth/AWSCredentialsProvider;", "convertInput", "", "data", "Lorg/neo4j/graphdb/Node;", "entities", "Lcom/amazonaws/services/comprehend/model/BatchDetectEntitiesResult;", "batchId", "", "getAwsBasicCredentials", "Lcom/amazonaws/auth/AWSCredentials;", "keyPhrases", "Lcom/amazonaws/services/comprehend/model/BatchDetectKeyPhrasesResult;", "Lapoc/result/MapResult;", "sentiment", "Lcom/amazonaws/services/comprehend/model/BatchDetectSentimentResult;", "vision", "Companion", "apoc"})
@SourceDebugExtension(value={"SMAP\nRealAWSClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealAWSClient.kt\napoc/nlp/aws/RealAWSClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1549#2:112\n1620#2,3:113\n1549#2:116\n1620#2,3:117\n1549#2:120\n1620#2,3:121\n1549#2:124\n1620#2,3:125\n1549#2:128\n1620#2,3:129\n*S KotlinDebug\n*F\n+ 1 RealAWSClient.kt\napoc/nlp/aws/RealAWSClient\n*L\n82#1:112\n82#1:113,3\n87#1:116\n87#1:117,3\n96#1:120\n96#1:121,3\n101#1:124\n101#1:125,3\n109#1:128\n109#1:129,3\n*E\n"})
public final class RealAWSClient
implements AWSClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Log log;
    @Nullable
    private final String apiKey;
    @Nullable
    private final String apiSecret;
    @NotNull
    private final String apiSessionToken;
    @NotNull
    private final String region;
    @NotNull
    private final String language;
    @NotNull
    private final String nodeProperty;
    private final AmazonComprehend awsClient;
    @NotNull
    private static final String missingCredentialError = "\n                Error during AWS credentials retrieving.\n                Make sure the key ID and the Secret Key are defined via `key` and `secret` parameters \n                or via one of these ways: https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/auth/DefaultAWSCredentialsProviderChain.html:\n                ";

    public RealAWSClient(@NotNull Map<String, ? extends Object> config, @NotNull Log log) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.log = log;
        Object object = config.get("key");
        this.apiKey = object != null ? object.toString() : null;
        Object object2 = config.get("secret");
        this.apiSecret = object2 != null ? object2.toString() : null;
        this.apiSessionToken = String.valueOf(config.get("token"));
        this.region = config.getOrDefault("region", "us-east-1").toString();
        this.language = config.getOrDefault("language", "en").toString();
        this.nodeProperty = config.getOrDefault("nodeProperty", "text").toString();
        this.awsClient = (AmazonComprehend)((AmazonComprehendClientBuilder)((AmazonComprehendClientBuilder)AmazonComprehendClientBuilder.standard().withCredentials(this.awsStaticCredentialsProvider())).withRegion(this.region)).build();
    }

    private final AWSCredentialsProvider awsStaticCredentialsProvider() {
        CharSequence charSequence = this.apiKey;
        return !(charSequence == null || charSequence.length() == 0) && !((charSequence = (CharSequence)this.apiSecret) == null || charSequence.length() == 0) ? (AWSCredentialsProvider)new AWSStaticCredentialsProvider(this.getAwsBasicCredentials()) : (AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain();
    }

    private final AWSCredentials getAwsBasicCredentials() {
        return ((CharSequence)this.apiSessionToken).length() == 0 ? (AWSCredentials)new BasicAWSCredentials(this.apiKey, this.apiSecret) : (AWSCredentials)new BasicSessionCredentials(this.apiKey, this.apiSecret, this.apiSessionToken);
    }

    @Override
    @Nullable
    public BatchDetectEntitiesResult entities(@NotNull List<? extends Node> data, int batchId) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        try {
            List<String> convertedData = this.convertInput(data);
            BatchDetectEntitiesRequest batch = new BatchDetectEntitiesRequest().withTextList((Collection)convertedData).withLanguageCode(this.language);
            return this.awsClient.batchDetectEntities(batch);
        }
        catch (Exception e) {
            throw new RuntimeException(missingCredentialError + e);
        }
    }

    @Override
    @Nullable
    public BatchDetectKeyPhrasesResult keyPhrases(@NotNull List<? extends Node> data, int batchId) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        try {
            List<String> convertedData = this.convertInput(data);
            BatchDetectKeyPhrasesRequest batch = new BatchDetectKeyPhrasesRequest().withTextList((Collection)convertedData).withLanguageCode(this.language);
            return this.awsClient.batchDetectKeyPhrases(batch);
        }
        catch (Exception e) {
            throw new RuntimeException(missingCredentialError + e);
        }
    }

    @Override
    @Nullable
    public BatchDetectSentimentResult sentiment(@NotNull List<? extends Node> data, int batchId) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        try {
            List<String> convertedData = this.convertInput(data);
            BatchDetectSentimentRequest batch = new BatchDetectSentimentRequest().withTextList((Collection)convertedData).withLanguageCode(this.language);
            return this.awsClient.batchDetectSentiment(batch);
        }
        catch (Exception e) {
            throw new RuntimeException(missingCredentialError + e);
        }
    }

    @NotNull
    public final List<MapResult> sentiment(@NotNull List<? extends Node> data, @NotNull Map<String, ? extends Object> config) {
        BatchDetectSentimentItemResult it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        List<String> convertedData = this.convertInput(data);
        BatchDetectSentimentRequest batch = new BatchDetectSentimentRequest().withTextList((Collection)convertedData);
        BatchDetectSentimentResult batchDetectEntities = this.awsClient.batchDetectSentiment(batch);
        List allData = batchDetectEntities.getResultList();
        List list = batchDetectEntities.getErrorList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"batchDetectEntities.errorList");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            BatchItemError batchItemError = (BatchItemError)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Integer n = it.getIndex();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"it.index");
            collection.add(convertedData.get(((Number)n).intValue()));
        }
        List batchToRetry = (List)destination$iv$iv;
        batch = new BatchDetectSentimentRequest().withTextList((Collection)batchToRetry);
        batchDetectEntities = this.awsClient.batchDetectSentiment(batch);
        Intrinsics.checkNotNullExpressionValue((Object)allData, (String)"allData");
        $this$map$iv = allData;
        List list2 = batchDetectEntities.getResultList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"batchDetectEntities.resultList");
        CollectionsKt.addAll((Collection)$this$map$iv, (Iterable)list2);
        $this$map$iv = allData;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (BatchDetectSentimentItemResult)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ObjectMapper objectMapper = JsonUtil.OBJECT_MAPPER;
            Intrinsics.checkNotNull((Object)objectMapper);
            Object object = objectMapper.convertValue((Object)it, Map.class);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            collection.add(new MapResult((Map)object));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<MapResult> keyPhrases(@NotNull List<? extends Node> data, @NotNull Map<String, ? extends Object> config) {
        BatchDetectKeyPhrasesItemResult it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        List<String> convertedData = this.convertInput(data);
        BatchDetectKeyPhrasesRequest batch = new BatchDetectKeyPhrasesRequest().withTextList((Collection)convertedData);
        BatchDetectKeyPhrasesResult batchDetectEntities = this.awsClient.batchDetectKeyPhrases(batch);
        List allData = batchDetectEntities.getResultList();
        List list = batchDetectEntities.getErrorList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"batchDetectEntities.errorList");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            BatchItemError batchItemError = (BatchItemError)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Integer n = it.getIndex();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"it.index");
            collection.add(convertedData.get(((Number)n).intValue()));
        }
        List batchToRetry = (List)destination$iv$iv;
        batch = new BatchDetectKeyPhrasesRequest().withTextList((Collection)batchToRetry);
        batchDetectEntities = this.awsClient.batchDetectKeyPhrases(batch);
        Intrinsics.checkNotNullExpressionValue((Object)allData, (String)"allData");
        $this$map$iv = allData;
        List list2 = batchDetectEntities.getResultList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"batchDetectEntities.resultList");
        CollectionsKt.addAll((Collection)$this$map$iv, (Iterable)list2);
        $this$map$iv = allData;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (BatchDetectKeyPhrasesItemResult)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ObjectMapper objectMapper = JsonUtil.OBJECT_MAPPER;
            Intrinsics.checkNotNull((Object)objectMapper);
            Object object = objectMapper.convertValue((Object)it, Map.class);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            collection.add(new MapResult((Map)object));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<MapResult> vision(@NotNull Object data, @NotNull Map<String, ? extends Object> config) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        throw new UnsupportedOperationException("Rekognition is not yet implemented");
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> convertInput(List<? extends Node> data) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = data;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void node;
            Node node2 = (Node)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(node.getProperty(this.nodeProperty).toString());
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lapoc/nlp/aws/RealAWSClient$Companion;", "", "()V", "missingCredentialError", "", "getMissingCredentialError", "()Ljava/lang/String;", "apoc"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getMissingCredentialError() {
            return missingCredentialError;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

