/*
 * Decompiled with CFR 0.152.
 */
package apoc.mongodb;

import apoc.Extended;
import apoc.mongodb.MongoDBUtils;
import apoc.mongodb.MongoDbCollInterface;
import apoc.mongodb.MongoDbConfig;
import apoc.result.LongResult;
import apoc.result.MapResult;
import apoc.util.JsonUtil;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class Mongo {
    @Context
    public Log log;

    @Procedure(value="apoc.mongo.aggregate")
    @Description(value="apoc.mongo.aggregate(uri, pipeline, $config) yield value - perform an aggregate operation on mongodb collection")
    public Stream<MapResult> aggregate(@Name(value="uri") String uri, @Name(value="pipeline") List<Map<String, Object>> pipeline, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        MongoDbConfig conf = MongoDBUtils.getMongoConfig(config);
        return this.executeMongoQuery(uri, conf, coll -> coll.aggregate(MongoDBUtils.getDocuments(pipeline)).map(MapResult::new), this.getExceptionConsumer("apoc.mongo.aggregate", uri, config));
    }

    @Procedure(value="apoc.mongo.count")
    @Description(value="apoc.mongo.count(uri, query, $config) yield value - perform a count operation on mongodb collection")
    public Stream<LongResult> count(@Name(value="uri") String uri, @Name(value="query") Object query, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        MongoDbConfig conf = MongoDBUtils.getMongoConfig(config);
        return this.executeMongoQuery(uri, conf, coll -> {
            long count = coll.count(MongoDBUtils.getDocument(query));
            return Stream.of(new LongResult(Long.valueOf(count)));
        }, this.getExceptionConsumer("apoc.mongo.count", uri, config));
    }

    @Procedure(value="apoc.mongo.find")
    @Description(value="apoc.mongo.find(uri, query, $config) yield value - perform a find operation on mongodb collection")
    public Stream<MapResult> find(@Name(value="uri") String uri, @Name(value="query", defaultValue="null") Object query, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        MongoDbConfig conf = MongoDBUtils.getMongoConfig(config);
        return this.executeMongoQuery(uri, conf, coll -> coll.find(MongoDBUtils.getDocument(query), conf.getProject(), conf.getSort(), conf.getSkip(), conf.getLimit()).map(MapResult::new), this.getExceptionConsumer("apoc.mongo.find", uri, config));
    }

    @Procedure(value="apoc.mongo.insert")
    @Description(value="apoc.mongo.insert(uri, documents, $config) yield value - inserts the given documents into the mongodb collection")
    public void insert(@Name(value="uri") String uri, @Name(value="documents") List<Object> documents, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        MongoDbConfig conf = MongoDBUtils.getMongoConfig(config);
        try (MongoDbCollInterface coll = this.getColl(uri, conf);){
            coll.insertDocs(documents.stream().map(MongoDBUtils::getDocument).collect(Collectors.toList()));
        }
        catch (Exception e) {
            this.mongoErrorLog("apoc.mongo.insert", uri, config, e, "documents = " + documents + ",");
            throw new RuntimeException(e);
        }
    }

    @Procedure(value="apoc.mongo.update")
    @Description(value="apoc.mongo.update(uri, query, update, $config) - updates the given documents from the mongodb collection and returns the number of affected documents")
    public Stream<LongResult> update(@Name(value="uri") String uri, @Name(value="query") Object query, @Name(value="update") Object update, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        MongoDbConfig conf = MongoDBUtils.getMongoConfig(config);
        return this.executeMongoQuery(uri, conf, coll -> Stream.of(new LongResult(Long.valueOf(coll.update(MongoDBUtils.getDocument(query), MongoDBUtils.getDocument(update))))), this.getExceptionConsumer("apoc.mongo.update", uri, config, "query = " + query + ",  update = " + update + ","));
    }

    @Procedure(value="apoc.mongo.delete")
    @Description(value="apoc.mongo.delete(uri, query, $config) - delete the given documents from the mongodb collection and returns the number of affected documents")
    public Stream<LongResult> delete(@Name(value="uri") String uri, @Name(value="query") Object query, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        MongoDbConfig conf = MongoDBUtils.getMongoConfig(config);
        return this.executeMongoQuery(uri, conf, coll -> Stream.of(new LongResult(Long.valueOf(coll.delete(MongoDBUtils.getDocument(query))))), this.getExceptionConsumer("apoc.mongo.delete", uri, config, "query = " + query + ","));
    }

    private Consumer<Exception> getExceptionConsumer(String procedureName, String uri, Map<String, Object> config) {
        return this.getExceptionConsumer(procedureName, uri, config, "");
    }

    private Consumer<Exception> getExceptionConsumer(String procedureName, String uri, Map<String, Object> config, String others) {
        return e -> this.mongoErrorLog(procedureName, uri, config, (Exception)e, others);
    }

    private void mongoErrorLog(String procedureName, String uri, Map<String, Object> config, Exception e, String optionalOthers) {
        this.log.error(procedureName + " - uri = '" + uri + "', " + optionalOthers + " config = " + JsonUtil.writeValueAsString(config), (Throwable)e);
    }

    private <T> Stream<T> executeMongoQuery(String uri, MongoDbConfig conf, Function<MongoDbCollInterface, Stream<T>> execute, Consumer<Exception> onError) {
        MongoDbCollInterface coll = null;
        try {
            coll = this.getColl(uri, conf);
            return (Stream)execute.apply(coll).onClose(coll::safeClose);
        }
        catch (Exception e) {
            if (coll != null) {
                coll.safeClose();
            }
            onError.accept(e);
            throw new RuntimeException("Error during connection", e);
        }
    }

    private MongoDbCollInterface getColl(@Name(value="url") String url, MongoDbConfig conf) {
        return MongoDbCollInterface.Factory.create(url, conf);
    }
}

