/*
 * Decompiled with CFR 0.152.
 */
package apoc.ml.aws;

import apoc.ml.aws.AWSConfig;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.tuple.Pair;

public class AwsSignatureV4Generator {
    public static final String AUTHORIZATION_KEY = "Authorization";

    public static void calculateAuthorizationHeaders(AWSConfig conf, String bodyString, Map<String, Object> headers, String awsServiceName) throws MalformedURLException {
        if (headers.containsKey(AUTHORIZATION_KEY)) {
            return;
        }
        byte[] body = AwsSignatureV4Generator.getBytes(bodyString);
        String isoDateTime = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'").format(ZonedDateTime.now(ZoneOffset.UTC));
        URL url = new URL(conf.getEndpoint());
        String host = url.getHost();
        String path = url.getPath();
        String query = url.getQuery();
        String bodySha256 = AwsSignatureV4Generator.hex(AwsSignatureV4Generator.toSha256(body));
        String isoDateOnly = isoDateTime.substring(0, 8);
        headers.put("Host", host);
        headers.put("X-Amz-Date", isoDateTime);
        Pair<String, String> pairSignedHeaderAndCanonicalHash = AwsSignatureV4Generator.createCanonicalRequest(conf.getMethod(), headers, path, query, bodySha256);
        Pair<String, String> pairCredentialAndStringSign = AwsSignatureV4Generator.createStringToSign(conf.getRegion(), isoDateTime, isoDateOnly, pairSignedHeaderAndCanonicalHash, awsServiceName);
        String signature = AwsSignatureV4Generator.calculateSignature(conf.getSecretKey(), conf.getRegion(), isoDateOnly, (String)pairCredentialAndStringSign.getRight(), awsServiceName);
        AwsSignatureV4Generator.createAuthorizationHeader(conf, headers, pairSignedHeaderAndCanonicalHash, pairCredentialAndStringSign, signature);
    }

    private static byte[] getBytes(String bodyString) {
        if (bodyString == null) {
            bodyString = "";
        }
        return bodyString.getBytes();
    }

    private static void createAuthorizationHeader(AWSConfig conf, Map<String, Object> headers, Pair<String, String> pairSignedHeaderAndCanonicalHash, Pair<String, String> pairCredentialAndStringSign, String signature) {
        String authStringParameter = "AWS4-HMAC-SHA256 Credential=" + conf.getKeyId() + "/" + (String)pairCredentialAndStringSign.getLeft() + ", SignedHeaders=" + (String)pairSignedHeaderAndCanonicalHash.getLeft() + ", Signature=" + signature;
        headers.put(AUTHORIZATION_KEY, authStringParameter);
    }

    private static Pair<String, String> createStringToSign(String awsRegion, String isoDateTime, String isoJustDate, Pair<String, String> pairSignedHeaderCanonicalHash, String awsServiceName) {
        ArrayList<Object> stringToSignLines = new ArrayList<Object>();
        stringToSignLines.add("AWS4-HMAC-SHA256");
        stringToSignLines.add(isoDateTime);
        String credentialScope = isoJustDate + "/" + awsRegion + "/" + awsServiceName + "/aws4_request";
        stringToSignLines.add(credentialScope);
        stringToSignLines.add((String)pairSignedHeaderCanonicalHash.getRight());
        String stringToSign = String.join((CharSequence)"\n", stringToSignLines);
        return Pair.of((Object)credentialScope, (Object)stringToSign);
    }

    private static Pair<String, String> createCanonicalRequest(String method, Map<String, Object> headers, String path, String query, String bodySha256) {
        ArrayList<Object> canonicalRequestLines = new ArrayList<Object>();
        canonicalRequestLines.add(method);
        canonicalRequestLines.add(path);
        canonicalRequestLines.add(query);
        ArrayList<String> hashedHeaders = new ArrayList<String>();
        List<String> headerKeysSorted = headers.keySet().stream().sorted(Comparator.comparing(e -> e.toLowerCase(Locale.US))).toList();
        for (String key : headerKeysSorted) {
            hashedHeaders.add(key.toLowerCase(Locale.US));
            canonicalRequestLines.add(key.toLowerCase(Locale.US) + ":" + AwsSignatureV4Generator.normalizeSpaces((String)headers.get(key)));
        }
        canonicalRequestLines.add(null);
        String signedHeaders = String.join((CharSequence)";", hashedHeaders);
        canonicalRequestLines.add(signedHeaders);
        canonicalRequestLines.add(bodySha256);
        String canonicalRequestBody = canonicalRequestLines.stream().map(line -> line == null ? "" : line).collect(Collectors.joining("\n"));
        String canonicalRequestHash = AwsSignatureV4Generator.hex(AwsSignatureV4Generator.toSha256(canonicalRequestBody.getBytes(StandardCharsets.UTF_8)));
        return Pair.of((Object)signedHeaders, (Object)canonicalRequestHash);
    }

    private static String calculateSignature(String awsSecret, String awsRegion, String isoJustDate, String stringToSign, String awsServiceName) {
        byte[] kDate = AwsSignatureV4Generator.toHmac(("AWS4" + awsSecret).getBytes(StandardCharsets.UTF_8), isoJustDate);
        byte[] kRegion = AwsSignatureV4Generator.toHmac(kDate, awsRegion);
        byte[] kService = AwsSignatureV4Generator.toHmac(kRegion, awsServiceName);
        byte[] kSigning = AwsSignatureV4Generator.toHmac(kService, "aws4_request");
        return AwsSignatureV4Generator.hex(AwsSignatureV4Generator.toHmac(kSigning, stringToSign));
    }

    private static String normalizeSpaces(String value) {
        return value.replaceAll("\\s+", " ").trim();
    }

    public static String hex(byte[] a) {
        StringBuilder sb = new StringBuilder(a.length * 2);
        for (byte b : a) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private static byte[] toSha256(byte[] bytes) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(bytes);
            return digest.digest();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] toHmac(byte[] key, String msg) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key, "HmacSHA256"));
            return mac.doFinal(msg.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

