/*
 * Decompiled with CFR 0.152.
 */
package apoc.ml;

import apoc.ApocConfig;
import apoc.ml.VertexAI;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public abstract class VertexAIHandler {
    public static final String RESOURCE_CONF_KEY = "resource";
    public static final String STREAM_RESOURCE = "streamGenerateContent";
    public static final String PREDICT_RESOURCE = "predict";
    private static final String DEFAULT_BASE_URL = "https://{region}-aiplatform.googleapis.com/v1/projects/{project}/locations/{region}/publishers/google/models/{model}:{resource}";
    public static final String DEFAULT_REGION = "us-central1";

    public abstract String getDefaultResource();

    public abstract Map<String, Object> getBody(Object var1, Map<String, Object> var2, Collection<String> var3);

    public abstract String getJsonPath();

    public String getFullUrl(Map<String, Object> configuration, ApocConfig apocConfig, String defaultModel, String project) {
        String model = configuration.getOrDefault("model", defaultModel).toString();
        String region = configuration.getOrDefault("region", DEFAULT_REGION).toString();
        String resource = configuration.getOrDefault(RESOURCE_CONF_KEY, this.getDefaultResource()).toString();
        project = Objects.toString(project, "");
        String endpoint = this.getUrlTemplate(configuration, apocConfig);
        if (StringUtils.isBlank((CharSequence)endpoint) && StringUtils.isBlank((CharSequence)project)) {
            throw new IllegalArgumentException("Either project parameter or endpoint config. must not be empty");
        }
        return endpoint.replace("{region}", region).replace("{project}", project).replace("{model}", model).replace("{resource}", resource);
    }

    private String getUrlTemplate(Map<String, Object> procConfig, ApocConfig apocConfig) {
        return (String)procConfig.getOrDefault("endpoint", apocConfig.getString("apoc.ml.vertexai.url", System.getProperty("apoc.ml.vertexai.url", DEFAULT_BASE_URL)));
    }

    private static class Custom
    extends VertexAIHandler {
        private Custom() {
        }

        @Override
        public String getDefaultResource() {
            return VertexAIHandler.STREAM_RESOURCE;
        }

        @Override
        public Map<String, Object> getBody(Object inputs, Map<String, Object> configuration, Collection<String> retainKeys) {
            return (Map)inputs;
        }

        @Override
        public String getJsonPath() {
            return null;
        }
    }

    private static class Stream
    extends VertexAIHandler {
        private Stream() {
        }

        @Override
        public String getDefaultResource() {
            return VertexAIHandler.STREAM_RESOURCE;
        }

        @Override
        public Map<String, Object> getBody(Object inputs, Map<String, Object> configuration, Collection<String> retainKeys) {
            return Map.of("contents", inputs, "generation_config", VertexAI.getParameters(configuration, retainKeys));
        }

        @Override
        public String getJsonPath() {
            return "$[0].candidates";
        }
    }

    private static class Predict
    extends VertexAIHandler {
        private Predict() {
        }

        @Override
        public String getDefaultResource() {
            return VertexAIHandler.PREDICT_RESOURCE;
        }

        @Override
        public Map<String, Object> getBody(Object inputs, Map<String, Object> configuration, Collection<String> retainKeys) {
            return Map.of("instances", inputs, "parameters", VertexAI.getParameters(configuration, retainKeys));
        }

        @Override
        public String getJsonPath() {
            return "$.predictions";
        }
    }

    static enum Type {
        PREDICT(new Predict()),
        STREAM(new Stream()),
        CUSTOM(new Custom());

        private final VertexAIHandler handler;

        private Type(VertexAIHandler handler) {
            this.handler = handler;
        }

        public VertexAIHandler get() {
            return this.handler;
        }
    }
}

