/*
 * Decompiled with CFR 0.152.
 */
package apoc.gephi;

import apoc.Extended;
import apoc.graph.GraphsUtils;
import apoc.result.ExportProgressInfo;
import apoc.util.ExtendedUtil;
import apoc.util.JsonUtil;
import apoc.util.MapUtil;
import apoc.util.UrlResolver;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class Gephi {
    @Context
    public URLAccessChecker urlAccessChecker;
    public static final int WIDTH = 1000;
    public static final int HEIGHT = 1000;
    private static final String[] CAPTIONS = new String[]{"name", "title", "label"};
    private static final List<String> RESERVED = Arrays.asList("label", "TYPE", "id", "source", "target", "weight", "directed");

    private String getGephiUrl(String hostOrKey) {
        return new UrlResolver("http", "localhost", 8080).getUrl("gephi", hostOrKey);
    }

    public static double doubleValue(Entity pc, String prop, Number defaultValue) {
        return Util.toDouble((Object)pc.getProperty(prop, (Object)defaultValue));
    }

    @Procedure
    @Description(value="apoc.gephi.add(url-or-key, workspace, data, weightproperty, ['exportproperty']) | streams passed in data to Gephi")
    public Stream<ExportProgressInfo> add(@Name(value="urlOrKey") String keyOrUrl, @Name(value="workspace") String workspace, @Name(value="data") Object data, @Name(value="weightproperty", defaultValue="null") String weightproperty, @Name(value="exportproperties", defaultValue="[]") List<String> exportproperties) {
        if (workspace == null) {
            workspace = "workspace0";
        }
        String url = this.getGephiUrl(keyOrUrl) + "/" + Util.encodeUrlComponent((String)workspace) + "?operation=updateGraph";
        long start = System.currentTimeMillis();
        HashSet<Node> nodes = new HashSet<Node>(1000);
        HashSet<Relationship> rels = new HashSet<Relationship>(10000);
        ArrayList<String> propertyNames = new ArrayList<String>(exportproperties);
        propertyNames.removeAll(RESERVED);
        if (GraphsUtils.extract((Object)data, nodes, rels)) {
            String payload = this.toGephiStreaming(nodes, rels, weightproperty, propertyNames.toArray(new String[propertyNames.size()]));
            JsonUtil.loadJson((Object)url, (Map)MapUtil.map((Object[])new Object[]{"method", "POST", "Content-Type", "application/json; charset=utf-8"}), (String)payload, (String)"", (boolean)true, null, null, (URLAccessChecker)this.urlAccessChecker).count();
            return Stream.of(new ExportProgressInfo(url, "graph", "gephi").update((long)nodes.size(), (long)rels.size(), (long)nodes.size()).done(start));
        }
        return Stream.empty();
    }

    private String toGephiStreaming(Collection<Node> nodes, Collection<Relationship> rels, String weightproperty, String[] exportproperties) {
        return Stream.concat(this.toGraphStream(nodes, "an", weightproperty, exportproperties), this.toGraphStream(rels, "ae", weightproperty, exportproperties)).collect(Collectors.joining("\r\n"));
    }

    private Stream<String> toGraphStream(Collection<? extends Entity> source, String operation, String weightproperty, String[] exportproperties) {
        HashMap colors = new HashMap();
        return source.stream().map(n -> MapUtil.map((Object[])new Object[]{operation, this.data((Entity)n, colors, weightproperty, exportproperties)})).map(Util::toJson);
    }

    private Map<String, Object> data(Entity pc, Map<String, Map<String, Object>> colors, String weightproperty, String[] exportproperties) {
        if (pc instanceof Node) {
            Node n = (Node)pc;
            String labels = Util.labelString((Node)n);
            Map attributes = MapUtil.map((Object[])new Object[]{"label", this.caption(n), "TYPE", labels});
            attributes.putAll(this.positions());
            attributes.putAll(this.color(labels, colors));
            if (exportproperties.length > 0) {
                attributes.putAll(n.getProperties(exportproperties));
            }
            return MapUtil.map((Object[])new Object[]{this.idStr(n), attributes});
        }
        if (pc instanceof Relationship) {
            Relationship r = (Relationship)pc;
            String type = r.getType().name();
            Map attributes = MapUtil.map((Object[])new Object[]{"label", type, "TYPE", type});
            Double weight = ExtendedUtil.doubleValue((Entity)r, weightproperty, 1.0);
            attributes.putAll(MapUtil.map((Object[])new Object[]{"source", this.idStr(r.getStartNode()), "target", this.idStr(r.getEndNode()), "directed", true, "weight", weight}));
            attributes.putAll(this.color(type, colors));
            if (exportproperties.length > 0) {
                attributes.putAll(r.getProperties(exportproperties));
            }
            return MapUtil.map((Object[])new Object[]{String.valueOf(r.getId()), attributes});
        }
        return MapUtil.map((Object[])new Object[0]);
    }

    private Map<String, Object> positions() {
        return MapUtil.map((Object[])new Object[]{"size", 10, "x", 500.0 - Math.random() * 1000.0, "y", 500.0 - Math.random() * 1000.0});
    }

    private Map<String, Object> color(String type, Map<String, Map<String, Object>> colors) {
        return colors.computeIfAbsent(type, k -> {
            int rgb = type.hashCode();
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb & 0xFF) / 255.0f;
            return MapUtil.map((Object[])new Object[]{"r", Float.valueOf(r), "g", Float.valueOf(g), "b", Float.valueOf(b)});
        });
    }

    private String idStr(Node n) {
        return String.valueOf(n.getId());
    }

    private String caption(Node n) {
        for (String caption : CAPTIONS) {
            if (!n.hasProperty(caption)) continue;
            return n.getProperty(caption).toString();
        }
        String first = null;
        for (String caption : CAPTIONS) {
            for (String key : n.getPropertyKeys()) {
                if (first == null) {
                    first = key;
                }
                if (!key.toLowerCase().contains(caption)) continue;
                return n.getProperty(key).toString();
            }
        }
        return first == null ? this.idStr(n) : n.getProperty(first).toString();
    }
}

