/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.parquet;

import apoc.convert.ConvertUtils;
import apoc.util.JsonUtil;
import apoc.util.Util;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.NanoTime;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public class ParquetUtil {
    public static String FIELD_ID = "__id";
    public static String FIELD_LABELS = "__labels";
    public static String FIELD_SOURCE_ID = "__source_id";
    public static String FIELD_TARGET_ID = "__target_id";
    public static String FIELD_TYPE = "__type";

    public static String fromMetaType(apoc.meta.Types type) {
        switch (type) {
            case INTEGER: {
                return "LONG";
            }
            case FLOAT: {
                return "DOUBLE";
            }
            case LIST: {
                String inner = type.toString().substring("LIST OF ".length()).trim();
                apoc.meta.Types innerType = apoc.meta.Types.from((String)inner);
                if (innerType == apoc.meta.Types.LIST || innerType == apoc.meta.Types.MAP) {
                    return "ANYARRAY";
                }
                return ParquetUtil.fromMetaType(innerType) + "ARRAY";
            }
        }
        return type.name().replaceAll("_", "").toUpperCase();
    }

    public static Group mapToRecord(MessageType schema, Map<String, Object> map) {
        SimpleGroupFactory factory = new SimpleGroupFactory(schema);
        Group group = factory.newGroup();
        map.forEach((k, v) -> {
            try {
                Type type = schema.getType(k);
                if (type.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.ListLogicalTypeAnnotation) {
                    ParquetUtil.appendList(group, k, v);
                } else {
                    ParquetUtil.appendElement(group, k, v, schema);
                }
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        });
        return group;
    }

    public static void appendList(Group group, String k, Object v) {
        Group group1 = group.addGroup(k);
        ConvertUtils.convertToList((Object)v).forEach(item -> {
            Group group2 = group1.addGroup(0);
            group2.add(0, item.toString());
        });
    }

    private static long writeDateMilliVector(Object value) {
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).toInstant(ZoneOffset.UTC).toEpochMilli();
        }
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toInstant().toEpochMilli();
        }
        if (value instanceof OffsetDateTime) {
            return ((OffsetDateTime)value).toInstant().toEpochMilli();
        }
        return (Long)value;
    }

    public static <T> void appendElement(Group group, String fieldName, Object value, MessageType schema) {
        if (value == null) {
            return;
        }
        PrimitiveType.PrimitiveTypeName typeName = schema.getType(fieldName).asPrimitiveType().getPrimitiveTypeName();
        if (typeName.equals((Object)PrimitiveType.PrimitiveTypeName.INT64)) {
            group.append(fieldName, ParquetUtil.writeDateMilliVector(value));
        } else if (typeName.equals((Object)PrimitiveType.PrimitiveTypeName.BINARY)) {
            group.append(fieldName, ParquetUtil.serializeValue(value));
        } else if (value instanceof Integer) {
            group.append(fieldName, ((Integer)value).intValue());
        } else if (value instanceof Float) {
            group.append(fieldName, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            group.append(fieldName, ((Double)value).doubleValue());
        } else if (value instanceof Long) {
            group.append(fieldName, ((Long)value).longValue());
        } else if (value instanceof NanoTime) {
            group.append(fieldName, (NanoTime)value);
        } else if (value instanceof Boolean) {
            group.append(fieldName, ((Boolean)value).booleanValue());
        } else {
            group.append(fieldName, ParquetUtil.serializeValue(value));
        }
    }

    private static String serializeValue(Object val) {
        if (val instanceof Node) {
            Node value = (Node)val;
            Map allProperties = value.getAllProperties();
            allProperties.put(FIELD_ID, value.getId());
            allProperties.put(FIELD_LABELS, Util.labelStrings((Node)value));
            return JsonUtil.writeValueAsString((Object)allProperties);
        }
        if (val instanceof Relationship) {
            Relationship value = (Relationship)val;
            Map allProperties = value.getAllProperties();
            allProperties.put(FIELD_ID, value.getId());
            allProperties.put(FIELD_SOURCE_ID, value.getStartNodeId());
            allProperties.put(FIELD_TARGET_ID, value.getEndNodeId());
            allProperties.put(FIELD_TYPE, value.getType().name());
            return JsonUtil.writeValueAsString((Object)allProperties);
        }
        if (val instanceof Map) {
            return JsonUtil.writeValueAsString((Object)val);
        }
        return val.toString();
    }

    public static void addListItem(String fieldName, Types.GroupBuilder test) {
        PrimitiveType element = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("element");
        GroupType groupType = (GroupType)Types.optionalList().element((Type)element).named(fieldName);
        test.addField((Type)groupType);
    }

    static void toField(String fieldName, Set<String> propertyTypes, Types.GroupBuilder builder) {
        if (propertyTypes.size() > 1) {
            ParquetUtil.getSchemaFieldAssembler(builder, fieldName, "String");
        } else {
            ParquetUtil.getSchemaFieldAssembler(builder, fieldName, propertyTypes.iterator().next());
        }
    }

    public static void getField(Types.GroupBuilder builder, PrimitiveType.PrimitiveTypeName type, String fieldName) {
        builder.addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)type).named(fieldName));
    }

    private static void getSchemaFieldAssembler(Types.GroupBuilder builder, String fieldName, String propertyType) {
        switch (propertyType = propertyType.toUpperCase()) {
            case "BOOLEAN": {
                builder.addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN).named(fieldName));
                break;
            }
            case "LONG": {
                builder.addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named(fieldName));
                break;
            }
            case "DOUBLE": {
                builder.addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE).named(fieldName));
                break;
            }
            case "DATETIME": {
                ParquetUtil.addDateTimeField(builder, fieldName, true);
                break;
            }
            case "LOCALDATETIME": {
                ParquetUtil.addDateTimeField(builder, fieldName, false);
                break;
            }
            case "DATE": {
                PrimitiveType type = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.DateLogicalTypeAnnotation.dateType())).named(fieldName);
                builder.addField((Type)type);
                break;
            }
            case "DURATION": 
            case "NODE": 
            case "RELATIONSHIP": 
            case "POINT": {
                builder.addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named(fieldName));
                break;
            }
            default: {
                if (propertyType.endsWith("ARRAY")) {
                    ParquetUtil.addListItem(fieldName, builder);
                    break;
                }
                builder.addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named(fieldName));
            }
        }
    }

    private static Types.BaseGroupBuilder addDateTimeField(Types.GroupBuilder builder, String fieldName, boolean isAdjustedToUTC) {
        LogicalTypeAnnotation.TimestampLogicalTypeAnnotation type = LogicalTypeAnnotation.TimestampLogicalTypeAnnotation.timestampType((boolean)isAdjustedToUTC, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS);
        PrimitiveType primitiveType = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)type)).named(fieldName);
        return builder.addField((Type)primitiveType);
    }
}

